/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.grpc.Channel;
import io.grpc.ClientCall;
import javax.annotation.Nullable;

public class ChannelInstrumentation
extends BaseInstrumentation {
    public ChannelInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc").and(ElementMatchers.nameContains("Channel"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.Channel"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("newCall");
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    private static void onExit(@Advice.This Channel channel, @Advice.Return @Nullable ClientCall<?, ?> clientCall, @Advice.Thrown @Nullable Throwable thrown) {
        if (clientCall == null || grpcHelperManager == null) {
            return;
        }
        GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.class);
        if (helper != null) {
            helper.enrichSpanContext(clientCall, channel.authority());
        }
    }
}

