/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class ClientCallImplInstrumentation
extends BaseInstrumentation {
    public static final Collection<Class<? extends ElasticApmInstrumentation>> RESPONSE_LISTENER_INSTRUMENTATIONS = Arrays.asList(ListenerClose.class, ListenerReady.class, ListenerMessage.class, ListenerHeaders.class);

    public ClientCallImplInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc").and(ElementMatchers.nameEndsWith("ClientCallImpl"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.ClientCall"));
    }

    public static class ListenerReady
    extends ListenerInstrumentation {
        public ListenerReady(ElasticApmTracer tracer) {
            super(tracer, "onReady");
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Thrown @Nullable Throwable thrown) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.Listener.class);
            if (helper != null) {
                helper.captureListenerException(listener, thrown);
            }
        }
    }

    public static class ListenerHeaders
    extends ListenerInstrumentation {
        public ListenerHeaders(ElasticApmTracer tracer) {
            super(tracer, "onHeaders");
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Thrown @Nullable Throwable thrown) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.Listener.class);
            if (helper != null) {
                helper.captureListenerException(listener, thrown);
            }
        }
    }

    public static class ListenerMessage
    extends ListenerInstrumentation {
        public ListenerMessage(ElasticApmTracer tracer) {
            super(tracer, "onMessage");
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Thrown @Nullable Throwable thrown) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.Listener.class);
            if (helper != null) {
                helper.captureListenerException(listener, thrown);
            }
        }
    }

    public static class ListenerClose
    extends ListenerInstrumentation {
        public ListenerClose(ElasticApmTracer tracer) {
            super(tracer, "onClose");
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Thrown Throwable thrown) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.Listener.class);
            if (helper != null) {
                helper.endSpan(listener, thrown);
            }
        }
    }

    public static abstract class ListenerInstrumentation
    extends BaseInstrumentation {
        private final String methodName;

        protected ListenerInstrumentation(ElasticApmTracer tracer, String methodName) {
            super(tracer);
            this.methodName = methodName;
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named(this.methodName);
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.any();
        }
    }

    public static class Start
    extends ClientCallImplInstrumentation {
        public Start(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("start");
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This ClientCall<?, ?> clientCall, @Advice.Argument(value=0) ClientCall.Listener<?> listener, @Advice.Argument(value=1) Metadata headers) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            ElasticApmAgent.ensureInstrumented(listener.getClass(), RESPONSE_LISTENER_INSTRUMENTATIONS);
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ClientCall.class);
            if (helper != null) {
                helper.startSpan(clientCall, listener, headers);
            }
        }
    }

    public static class Constructor
    extends ClientCallImplInstrumentation {
        public Constructor(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isConstructor().and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.grpc.MethodDescriptor")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Nullable @Advice.Argument(value=0) MethodDescriptor<?, ?> method, @Advice.Local(value="span") Span span) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(MethodDescriptor.class);
            if (helper != null) {
                span = helper.createExitSpanAndActivate(tracer.currentTransaction(), method);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void onExit(@Advice.This ClientCall<?, ?> clientCall, @Advice.Local(value="span") @Nullable Span span) {
            if (tracer == null || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(MethodDescriptor.class);
            if (helper != null) {
                helper.registerSpanAndDeactivate(span, clientCall);
            }
        }
    }
}

