/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import javax.annotation.Nullable;

public class ServerCallHandlerInstrumentation
extends BaseInstrumentation {
    public ServerCallHandlerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc").and(ElementMatchers.nameContains("Unary"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.ServerCallHandler"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("startCall");
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void onEnter(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) ServerCall<?, ?> serverCall, @Advice.Argument(value=1) Metadata headers, @Advice.Local(value="transaction") Transaction transaction) {
        if (tracer == null || grpcHelperManager == null) {
            return;
        }
        GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.class);
        if (helper != null) {
            transaction = helper.startTransaction(tracer, clazz.getClassLoader(), serverCall, headers);
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    private static void onExit(@Advice.Thrown Throwable thrown, @Advice.Argument(value=0) ServerCall<?, ?> serverCall, @Advice.Return ServerCall.Listener<?> listener, @Advice.Local(value="transaction") @Nullable Transaction transaction) {
        if (tracer == null || grpcHelperManager == null || transaction == null) {
            return;
        }
        GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.class);
        if (helper != null) {
            helper.registerTransactionAndDeactivate(transaction, serverCall, listener);
        }
    }
}

