/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc.helper;

import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import javax.annotation.Nullable;

public class GrpcHelperImpl
implements GrpcHelper {
    private static final WeakConcurrentMap<ClientCall<?, ?>, Span> inFlightClientSpans;
    private static final WeakConcurrentMap<ClientCall.Listener<?>, ClientCall<?, ?>> inFlightClientListeners;
    private static final WeakConcurrentMap<ServerCall<?, ?>, Transaction> inFlightTransactions;
    private static final WeakConcurrentMap<ServerCall.Listener<?>, ServerCall<?, ?>> inFlightServerListeners;
    private static final WeakConcurrentMap.WithInlinedExpunction<String, Metadata.Key<String>> headerCache;
    private static final TextHeaderSetter<Metadata> headerSetter;
    private static final TextHeaderGetter<Metadata> headerGetter;

    @Override
    public Transaction startTransaction(ElasticApmTracer tracer, ClassLoader cl, ServerCall<?, ?> serverCall, Metadata headers) {
        MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
        if (methodDescriptor.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        Transaction transaction = tracer.startChildTransaction(headers, headerGetter, cl);
        if (transaction == null) {
            return null;
        }
        ((Transaction)transaction.withName(methodDescriptor.getFullMethodName())).withType("request").activate();
        return transaction;
    }

    @Override
    public void registerTransactionAndDeactivate(@Nullable Transaction transaction, ServerCall<?, ?> serverCall, ServerCall.Listener<?> listener) {
        if (null == transaction) {
            return;
        }
        inFlightTransactions.put(serverCall, transaction);
        inFlightServerListeners.put(listener, serverCall);
        transaction.deactivate();
    }

    @Nullable
    private Transaction getTransactionFromListener(ServerCall.Listener<?> listener) {
        ServerCall<?, ?> serverCall = inFlightServerListeners.get(listener);
        Transaction transaction = null;
        if (null != serverCall) {
            transaction = inFlightTransactions.get(serverCall);
        }
        return transaction;
    }

    @Override
    public void endTransaction(Status status, @Nullable Throwable thrown, ServerCall<?, ?> serverCall) {
        Transaction transaction = inFlightTransactions.remove(serverCall);
        if (transaction == null) {
            return;
        }
        this.endTransaction(status, thrown, transaction);
    }

    private void endTransaction(Status status, @Nullable Throwable thrown, Transaction transaction) {
        if (transaction.getResult() != null) {
            return;
        }
        ((Transaction)transaction.withResult(status.getCode().name()).captureException(thrown)).end();
    }

    @Override
    @Nullable
    public Transaction enterServerListenerMethod(ServerCall.Listener<?> listener) {
        Transaction transaction = this.getTransactionFromListener(listener);
        if (transaction != null) {
            transaction.activate();
        }
        return transaction;
    }

    @Override
    public void exitServerListenerMethod(@Nullable Throwable thrown, ServerCall.Listener<?> listener, @Nullable Transaction transaction, boolean isLastMethod) {
        if (transaction == null) {
            return;
        }
        transaction.deactivate();
        if (null != thrown) {
            this.endTransaction(Status.UNKNOWN, thrown, transaction);
            inFlightServerListeners.remove(listener);
        } else if (isLastMethod) {
            inFlightServerListeners.remove(listener);
        }
    }

    @Override
    @Nullable
    public Span createExitSpanAndActivate(@Nullable Transaction transaction, @Nullable MethodDescriptor<?, ?> method) {
        if (null == transaction) {
            return null;
        }
        if (method != null && method.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        Span span = transaction.createExitSpan();
        if (span == null) {
            return null;
        }
        return (Span)((Span)span.withName(method == null ? null : method.getFullMethodName())).withType("external").withSubtype("grpc").activate();
    }

    @Override
    public void registerSpanAndDeactivate(@Nullable Span span, ClientCall<?, ?> clientCall) {
        if (span != null) {
            inFlightClientSpans.put(clientCall, span);
            span.deactivate();
        }
    }

    @Override
    public void startSpan(ClientCall<?, ?> clientCall, ClientCall.Listener<?> responseListener, Metadata headers) {
        Span span = inFlightClientSpans.get(clientCall);
        if (span == null) {
            return;
        }
        inFlightClientListeners.put(responseListener, clientCall);
        span.propagateTraceContext(headers, headerSetter);
    }

    @Override
    public void endSpan(ClientCall.Listener<?> responseListener, @Nullable Throwable thrown) {
        ClientCall<?, ?> clientCall = inFlightClientListeners.get(responseListener);
        Span span = null;
        if (clientCall != null) {
            span = inFlightClientSpans.get(clientCall);
        }
        if (span == null) {
            return;
        }
        ((Span)span.captureException(thrown)).end();
        inFlightClientListeners.remove(responseListener);
        inFlightClientSpans.remove(clientCall);
    }

    @Override
    public void captureListenerException(ClientCall.Listener<?> responseListener, @Nullable Throwable thrown) {
        Span span;
        if (thrown != null && (span = this.getSpanFromListener(responseListener)) != null) {
            span.captureException(thrown);
        }
    }

    @Override
    public void enrichSpanContext(ClientCall<?, ?> clientCall, @Nullable String authority) {
        if (authority == null) {
            return;
        }
        Span span = inFlightClientSpans.get(clientCall);
        if (span == null) {
            return;
        }
        Destination destination = span.getContext().getDestination().withAddressPort(authority);
        destination.getService().withName("grpc").withResource(authority).withType("grpc");
    }

    @Nullable
    private Span getSpanFromListener(ClientCall.Listener<?> responseListener) {
        ClientCall<?, ?> clientCall = inFlightClientListeners.get(responseListener);
        Span span = null;
        if (clientCall != null) {
            span = inFlightClientSpans.get(clientCall);
        }
        return span;
    }

    private static Metadata.Key<String> getHeader(String headerName) {
        Metadata.Key key = headerCache.get(headerName);
        if (key == null) {
            key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headerCache.put(headerName, (Metadata.Key<String>)key);
        }
        return key;
    }

    static {
        inFlightClientListeners = new WeakConcurrentMap.WithInlinedExpunction();
        inFlightClientSpans = new WeakConcurrentMap.WithInlinedExpunction();
        inFlightServerListeners = new WeakConcurrentMap.WithInlinedExpunction();
        inFlightTransactions = new WeakConcurrentMap.WithInlinedExpunction();
        headerCache = new WeakConcurrentMap.WithInlinedExpunction();
        headerSetter = new GrpcHeaderSetter();
        headerGetter = new GrpcHeaderGetter();
    }

    public static class GrpcHeaderGetter
    extends AbstractHeaderGetter<String, Metadata>
    implements TextHeaderGetter<Metadata> {
        @Override
        @Nullable
        public String getFirstHeader(String headerName, Metadata carrier) {
            return (String)carrier.get(GrpcHelperImpl.getHeader(headerName));
        }
    }

    public static class GrpcHeaderSetter
    implements TextHeaderSetter<Metadata> {
        @Override
        public void setHeader(String headerName, String headerValue, Metadata carrier) {
            carrier.put(GrpcHelperImpl.getHeader(headerName), (Object)headerValue);
        }
    }
}

