/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServiceNameUtil;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.TracerConfiguration;
import co.elastic.apm.agent.impl.async.SpanInScopeCallableWrapper;
import co.elastic.apm.agent.impl.async.SpanInScopeRunnableWrapper;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.sampling.ProbabilitySampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.ObjectPoolFactory;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

public class ElasticApmTracer {
    private static final Logger logger = LoggerFactory.getLogger(ElasticApmTracer.class);
    private static final int MAX_POOLED_RUNNABLES = 256;
    private static final WeakConcurrentMap<ClassLoader, String> serviceNameByClassLoader = new WeakConcurrentMap.WithInlinedExpunction<ClassLoader, String>();
    private final ConfigurationRegistry configurationRegistry;
    private final StacktraceConfiguration stacktraceConfiguration;
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private final ObjectPool<Transaction> transactionPool;
    private final ObjectPool<Span> spanPool;
    private final ObjectPool<ErrorCapture> errorPool;
    private final ObjectPool<SpanInScopeRunnableWrapper> runnableSpanWrapperObjectPool;
    private final ObjectPool<SpanInScopeCallableWrapper<?>> callableSpanWrapperObjectPool;
    private final Reporter reporter;
    private final ObjectPoolFactory objectPoolFactory;
    private final ThreadLocal<Deque<AbstractSpan<?>>> activeStack = new ThreadLocal<Deque<AbstractSpan<?>>>(){

        @Override
        protected Deque<AbstractSpan<?>> initialValue() {
            return new ArrayDeque();
        }
    };
    private final ThreadLocal<Boolean> allowWrappingOnThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private final CoreConfiguration coreConfiguration;
    private final List<ActivationListener> activationListeners;
    private final MetricRegistry metricRegistry;
    private Sampler sampler;
    boolean assertionsEnabled = false;
    private volatile TracerState tracerState = TracerState.UNINITIALIZED;
    private volatile boolean currentlyUnderStress = false;
    private volatile boolean recordingConfigOptionSet;

    ElasticApmTracer(ConfigurationRegistry configurationRegistry, Reporter reporter, ObjectPoolFactory poolFactory) {
        this.metricRegistry = new MetricRegistry(configurationRegistry.getConfig(ReporterConfiguration.class));
        this.configurationRegistry = configurationRegistry;
        this.reporter = reporter;
        this.stacktraceConfiguration = configurationRegistry.getConfig(StacktraceConfiguration.class);
        int maxPooledElements = configurationRegistry.getConfig(ReporterConfiguration.class).getMaxQueueSize() * 2;
        this.coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        TracerConfiguration tracerConfiguration = configurationRegistry.getConfig(TracerConfiguration.class);
        this.recordingConfigOptionSet = tracerConfiguration.getRecordingConfig().get();
        tracerConfiguration.getRecordingConfig().addChangeListener(new ConfigurationOption.ChangeListener<Boolean>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Boolean oldValue, Boolean newValue) {
                ElasticApmTracer.this.recordingConfigChanged(oldValue, newValue);
            }
        });
        this.objectPoolFactory = poolFactory;
        this.transactionPool = poolFactory.createTransactionPool(maxPooledElements, this);
        this.spanPool = poolFactory.createSpanPool(maxPooledElements, this);
        this.errorPool = poolFactory.createErrorPool(maxPooledElements / 2, this);
        this.runnableSpanWrapperObjectPool = poolFactory.createRunnableWrapperPool(256, this);
        this.callableSpanWrapperObjectPool = poolFactory.createCallableWrapperPool(256, this);
        this.sampler = ProbabilitySampler.of(this.coreConfiguration.getSampleRate().get());
        this.coreConfiguration.getSampleRate().addChangeListener(new ConfigurationOption.ChangeListener<Double>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Double oldValue, Double newValue) {
                ElasticApmTracer.this.sampler = ProbabilitySampler.of(newValue);
            }
        });
        this.activationListeners = DependencyInjectingServiceLoader.load(ActivationListener.class, this);
        reporter.scheduleMetricReporting(this.metricRegistry, configurationRegistry.getConfig(ReporterConfiguration.class).getMetricsIntervalMs(), this);
        if (!$assertionsDisabled) {
            this.assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    @Nullable
    public Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader) {
        return this.startRootTransaction(this.sampler, -1L, initiatingClassLoader);
    }

    @Nullable
    public Transaction startRootTransaction(Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().start(TraceContext.asRoot(), null, epochMicros, sampler, initiatingClassLoader);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.startChildTransaction(headerCarrier, textHeadersGetter, this.sampler, -1L, initiatingClassLoader);
    }

    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().start(TraceContext.getFromTraceContextTextHeaders(), headerCarrier, textHeadersGetter, epochMicros, sampler, initiatingClassLoader);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.startChildTransaction(headerCarrier, binaryHeadersGetter, this.sampler, -1L, initiatingClassLoader);
    }

    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().start(TraceContext.getFromTraceContextBinaryHeaders(), headerCarrier, binaryHeadersGetter, epochMicros, sampler, initiatingClassLoader);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    private void afterTransactionStart(@Nullable ClassLoader initiatingClassLoader, Transaction transaction) {
        String serviceName;
        if (logger.isDebugEnabled()) {
            logger.debug("startTransaction {} {", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("starting transaction at", new RuntimeException("this exception is just used to record where the transaction has been started from"));
            }
        }
        if ((serviceName = this.getServiceName(initiatingClassLoader)) != null) {
            transaction.getTraceContext().setServiceName(serviceName);
        }
    }

    public void avoidWrappingOnThread() {
        this.allowWrappingOnThread.set(Boolean.FALSE);
    }

    public void allowWrappingOnThread() {
        this.allowWrappingOnThread.set(Boolean.TRUE);
    }

    public boolean isWrappingAllowedOnThread() {
        return this.allowWrappingOnThread.get() == Boolean.TRUE;
    }

    public Transaction noopTransaction() {
        return this.createTransaction().startNoop();
    }

    private Transaction createTransaction() {
        Transaction transaction = this.transactionPool.createInstance();
        while (transaction.getReferenceCount() != 0) {
            logger.warn("Tried to start a transaction with a non-zero reference count {} {}", (Object)transaction.getReferenceCount(), (Object)transaction);
            transaction = this.transactionPool.createInstance();
        }
        return transaction;
    }

    @Nullable
    public Transaction currentTransaction() {
        AbstractSpan<?> bottomOfStack = this.activeStack.get().peekLast();
        return bottomOfStack != null ? bottomOfStack.getTransaction() : null;
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext) {
        return this.startSpan(childContextCreator, parentContext, -1L);
    }

    public Span startSpan(AbstractSpan<?> parent, long epochMicros) {
        return this.startSpan(TraceContext.fromParent(), parent, epochMicros);
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros) {
        return this.createSpan().start(childContextCreator, parentContext, epochMicros);
    }

    private Span createSpan() {
        Span span = this.spanPool.createInstance();
        while (span.getReferenceCount() != 0) {
            logger.warn("Tried to start a span with a non-zero reference count {} {}", (Object)span.getReferenceCount(), (Object)span);
            span = this.spanPool.createInstance();
        }
        return span;
    }

    public void captureAndReportException(@Nullable Throwable e, ClassLoader initiatingClassLoader) {
        ErrorCapture errorCapture = this.captureException(System.currentTimeMillis() * 1000L, e, this.getActive(), initiatingClassLoader);
        if (errorCapture != null) {
            errorCapture.end();
        }
    }

    @Nullable
    public String captureAndReportException(long epochMicros, @Nullable Throwable e, @Nullable AbstractSpan<?> parent) {
        String id = null;
        ErrorCapture errorCapture = this.captureException(epochMicros, e, parent, null);
        if (errorCapture != null) {
            id = errorCapture.getTraceContext().getId().toString();
            errorCapture.end();
        }
        return id;
    }

    @Nullable
    public ErrorCapture captureException(@Nullable Throwable e, @Nullable AbstractSpan<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        return this.captureException(System.currentTimeMillis() * 1000L, e, parent, initiatingClassLoader);
    }

    @Nullable
    private ErrorCapture captureException(long epochMicros, @Nullable Throwable e, @Nullable AbstractSpan<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        if (e != null && !WildcardMatcher.isAnyMatch(this.coreConfiguration.getIgnoreExceptions(), e.getClass().getName())) {
            ErrorCapture error = this.errorPool.createInstance();
            error.withTimestamp(epochMicros);
            error.setException(e);
            Transaction currentTransaction = this.currentTransaction();
            if (currentTransaction != null) {
                error.setTransactionType(currentTransaction.getType());
                error.setTransactionSampled(currentTransaction.isSampled());
            }
            if (parent != null) {
                error.asChildOf(parent);
                parent.setNonDiscardable();
            } else {
                error.getTraceContext().getId().setToRandomValue();
                error.getTraceContext().setServiceName(this.getServiceName(initiatingClassLoader));
            }
            return error;
        }
        return null;
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }

    public <T extends ConfigurationOptionProvider> T getConfig(Class<T> configProvider) {
        return this.configurationRegistry.getConfig(configProvider);
    }

    public void endTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            logger.debug("endTransaction {}", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("ending transaction at", new RuntimeException("this exception is just used to record where the transaction has been ended from"));
            }
        }
        if (!transaction.isNoop()) {
            this.reporter.report(transaction);
        } else {
            transaction.decrementReferences();
        }
    }

    public void endSpan(Span span) {
        if (!span.isSampled()) {
            span.decrementReferences();
            return;
        }
        if (span.getDuration() < this.coreConfiguration.getSpanMinDuration().getMillis() * 1000L) {
            logger.debug("Span faster than span_min_duration. Request discarding {}", (Object)span);
            span.requestDiscarding();
        }
        if (span.isDiscarded()) {
            logger.debug("Discarding span {}", (Object)span);
            Transaction transaction = span.getTransaction();
            if (transaction != null) {
                transaction.getSpanCount().getDropped().incrementAndGet();
            }
            span.decrementReferences();
            return;
        }
        this.reportSpan(span);
    }

    private void reportSpan(Span span) {
        Transaction transaction;
        AbstractSpan<?> parent = span.getParent();
        if (parent != null && parent.isDiscarded()) {
            logger.warn("Reporting a child of an discarded span. The current span '{}' will not be shown in the UI. Consider deactivating span_min_duration.", (Object)span);
        }
        if ((transaction = span.getTransaction()) != null) {
            transaction.getSpanCount().getReported().incrementAndGet();
        }
        span.setNonDiscardable();
        long spanFramesMinDurationMs = this.stacktraceConfiguration.getSpanFramesMinDurationMs();
        if (spanFramesMinDurationMs != 0L && span.isSampled() && span.getStackFrames() == null && span.getDurationMs() >= (double)spanFramesMinDurationMs) {
            span.withStacktrace(new Throwable());
        }
        this.reporter.report(span);
    }

    public void endError(ErrorCapture error) {
        this.reporter.report(error);
    }

    public void recycle(Transaction transaction) {
        this.transactionPool.recycle(transaction);
    }

    public void recycle(Span span) {
        this.spanPool.recycle(span);
    }

    public void recycle(ErrorCapture error) {
        this.errorPool.recycle(error);
    }

    public Runnable wrapRunnable(Runnable delegate, AbstractSpan<?> span) {
        if (delegate instanceof SpanInScopeRunnableWrapper) {
            return delegate;
        }
        return this.runnableSpanWrapperObjectPool.createInstance().wrap(delegate, span);
    }

    public void recycle(SpanInScopeRunnableWrapper wrapper) {
        this.runnableSpanWrapperObjectPool.recycle(wrapper);
    }

    public <V> Callable<V> wrapCallable(Callable<V> delegate, AbstractSpan<?> span) {
        if (delegate instanceof SpanInScopeCallableWrapper) {
            return delegate;
        }
        return this.callableSpanWrapperObjectPool.createInstance().wrap(delegate, span);
    }

    public void recycle(SpanInScopeCallableWrapper<?> wrapper) {
        this.callableSpanWrapperObjectPool.recycle(wrapper);
    }

    public synchronized void stop() {
        this.tracerState = TracerState.STOPPED;
        logger.info("Tracer switched to STOPPED state");
        try {
            this.configurationRegistry.close();
            this.reporter.close();
        }
        catch (Exception e) {
            logger.warn("Suppressed exception while calling stop()", e);
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.stop();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling stop()", e);
            }
        }
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public ObjectPoolFactory getObjectPoolFactory() {
        return this.objectPoolFactory;
    }

    @Nullable
    public AbstractSpan<?> getActive() {
        return this.activeStack.get().peek();
    }

    public void registerSpanListener(ActivationListener activationListener) {
        this.activationListeners.add(activationListener);
    }

    public List<ActivationListener> getActivationListeners() {
        return this.activationListeners;
    }

    synchronized void start(List<LifecycleListener> lifecycleListeners) {
        if (this.tracerState != TracerState.UNINITIALIZED) {
            logger.warn("Trying to start an already initialized agent");
            return;
        }
        this.lifecycleListeners.addAll(lifecycleListeners);
        for (LifecycleListener lifecycleListener : lifecycleListeners) {
            try {
                lifecycleListener.start(this);
            }
            catch (Exception e) {
                logger.error("Failed to start " + lifecycleListener.getClass().getName(), e);
            }
        }
        this.tracerState = TracerState.RUNNING;
        if (this.recordingConfigOptionSet) {
            logger.info("Tracer switched to RUNNING state");
        } else {
            this.pause();
        }
    }

    public synchronized void onStressDetected() {
        this.currentlyUnderStress = true;
        if (this.tracerState == TracerState.RUNNING) {
            this.pause();
        }
    }

    public synchronized void onStressRelieved() {
        this.currentlyUnderStress = false;
        if (this.tracerState == TracerState.PAUSED && this.recordingConfigOptionSet) {
            this.resume();
        }
    }

    private synchronized void recordingConfigChanged(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue && this.tracerState == TracerState.RUNNING) {
            this.pause();
        } else if (!oldValue && newValue && this.tracerState == TracerState.PAUSED && !this.currentlyUnderStress) {
            this.resume();
        }
        this.recordingConfigOptionSet = newValue;
    }

    synchronized void pause() {
        if (this.tracerState != TracerState.RUNNING) {
            logger.warn("Attempting to pause the agent when it is already in a {} state", (Object)this.tracerState);
            return;
        }
        this.tracerState = TracerState.PAUSED;
        logger.info("Tracer switched to PAUSED state");
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.pause();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling pause()", e);
            }
        }
    }

    synchronized void resume() {
        if (this.tracerState != TracerState.PAUSED) {
            logger.warn("Attempting to resume the agent when it is in a {} state", (Object)this.tracerState);
            return;
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.resume();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling resume()", e);
            }
        }
        this.tracerState = TracerState.RUNNING;
        logger.info("Tracer switched to RUNNING state");
    }

    public boolean isRunning() {
        return this.tracerState == TracerState.RUNNING;
    }

    public TracerState getState() {
        return this.tracerState;
    }

    @Nullable
    public <T> T getLifecycleListener(Class<T> listenerClass) {
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            if (!listenerClass.isInstance(lifecycleListener)) continue;
            return (T)lifecycleListener;
        }
        return null;
    }

    public void activate(AbstractSpan<?> span) {
        if (logger.isDebugEnabled()) {
            logger.debug("Activating {} on thread {}", (Object)span, (Object)Thread.currentThread().getId());
        }
        span.incrementReferences();
        List<ActivationListener> activationListeners = this.getActivationListeners();
        int size = activationListeners.size();
        for (int i = 0; i < size; ++i) {
            try {
                activationListeners.get(i).beforeActivate(span);
                continue;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                logger.warn("Exception while calling {}#beforeActivate", (Object)activationListeners.get(i).getClass().getSimpleName(), (Object)t);
            }
        }
        this.activeStack.get().push(span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(AbstractSpan<?> span) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deactivating {} on thread {}", (Object)span, (Object)Thread.currentThread().getId());
        }
        try {
            Deque<AbstractSpan<?>> stack = this.activeStack.get();
            this.assertIsActive(span, stack.poll());
            List<ActivationListener> activationListeners = this.getActivationListeners();
            int size = activationListeners.size();
            for (int i = 0; i < size; ++i) {
                try {
                    activationListeners.get(i).afterDeactivate(span);
                    continue;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    logger.warn("Exception while calling {}#afterDeactivate", (Object)activationListeners.get(i).getClass().getSimpleName(), (Object)t);
                }
            }
        }
        finally {
            span.decrementReferences();
        }
    }

    private void assertIsActive(AbstractSpan<?> span, @Nullable AbstractSpan<?> currentlyActive) {
        if (span != currentlyActive) {
            logger.warn("Deactivating a span ({}) which is not the currently active span ({}). This can happen when not properly deactivating a previous span.", (Object)span, (Object)currentlyActive);
            if (this.assertionsEnabled) {
                throw new AssertionError((Object)"Deactivating a span that is not the active one");
            }
        }
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void overrideServiceNameForClassLoader(@Nullable ClassLoader classLoader, @Nullable String serviceName) {
        if (classLoader == null || serviceName == null || serviceName.isEmpty() || !this.coreConfiguration.getServiceNameConfig().isDefault()) {
            return;
        }
        if (!serviceNameByClassLoader.containsKey(classLoader)) {
            serviceNameByClassLoader.putIfAbsent(classLoader, ServiceNameUtil.replaceDisallowedChars(serviceName));
        }
    }

    @Nullable
    private String getServiceName(@Nullable ClassLoader initiatingClassLoader) {
        if (initiatingClassLoader == null) {
            return null;
        }
        return serviceNameByClassLoader.get(initiatingClassLoader);
    }

    public void resetServiceNameOverrides() {
        serviceNameByClassLoader.clear();
    }

    public static enum TracerState {
        UNINITIALIZED,
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

