/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.collections.LongList;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.context.AbstractContext;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderSetter;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public abstract class AbstractSpan<T extends AbstractSpan<T>>
implements Recyclable {
    public static final int PRIO_USER_SUPPLIED = 1000;
    public static final int PRIO_HIGH_LEVEL_FRAMEWORK = 100;
    public static final int PRIO_METHOD_SIGNATURE = 100;
    public static final int PRIO_LOW_LEVEL_FRAMEWORK = 10;
    public static final int PRIO_DEFAULT = 0;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSpan.class);
    protected static final double MS_IN_MICROS = TimeUnit.MILLISECONDS.toMicros(1L);
    protected final TraceContext traceContext;
    protected final StringBuilder name = new StringBuilder();
    protected final boolean collectBreakdownMetrics;
    protected final ElasticApmTracer tracer;
    private long timestamp;
    protected long duration;
    private ChildDurationTimer childDurations = new ChildDurationTimer();
    protected AtomicInteger references = new AtomicInteger();
    protected volatile boolean finished = true;
    private int namePriority = 0;
    private boolean discardRequested = false;
    private boolean isExit;
    @Nullable
    private LongList childIds;

    public int getReferenceCount() {
        return this.references.get();
    }

    public T requestDiscarding() {
        this.discardRequested = true;
        return (T)this;
    }

    public boolean isDiscarded() {
        return this.discardRequested && this.getTraceContext().isDiscardable();
    }

    @Nullable
    public abstract Transaction getTransaction();

    public AbstractSpan(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.traceContext = TraceContext.with64BitId(this.tracer);
        boolean selfTimeCollectionEnabled = !WildcardMatcher.isAnyMatch(tracer.getConfig(ReporterConfiguration.class).getDisableMetrics(), "span.self_time");
        boolean breakdownMetricsEnabled = tracer.getConfig(CoreConfiguration.class).isBreakdownMetricsEnabled();
        this.collectBreakdownMetrics = selfTimeCollectionEnabled && breakdownMetricsEnabled;
    }

    public boolean isReferenced() {
        return this.references.get() > 0;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getSelfDuration() {
        return this.duration - this.childDurations.getDuration();
    }

    public double getDurationMs() {
        return (double)this.duration / MS_IN_MICROS;
    }

    public StringBuilder getNameForSerialization() {
        return this.name;
    }

    @Nullable
    public StringBuilder getAndOverrideName(int namePriority) {
        return this.getAndOverrideName(namePriority, true);
    }

    @Nullable
    public StringBuilder getAndOverrideName(int namePriority, boolean overrideIfSamePriority) {
        boolean shouldOverride;
        boolean bl = overrideIfSamePriority ? namePriority >= this.namePriority : (shouldOverride = namePriority > this.namePriority);
        if (shouldOverride) {
            this.namePriority = namePriority;
            this.name.setLength(0);
            return this.name;
        }
        return null;
    }

    public String getNameAsString() {
        return this.name.toString();
    }

    public T appendToName(CharSequence cs) {
        return this.appendToName(cs, 0);
    }

    public T appendToName(CharSequence cs, int priority) {
        if (priority >= this.namePriority) {
            this.name.append(cs);
            this.namePriority = priority;
        }
        return this.thiz();
    }

    public T withName(@Nullable String name) {
        return this.withName(name, 0);
    }

    public T withName(@Nullable String name, int priority) {
        return this.withName(name, priority, true);
    }

    public T withName(@Nullable String name, int priority, boolean overrideIfSamePriority) {
        boolean shouldOverride;
        boolean bl = overrideIfSamePriority ? priority >= this.namePriority : (shouldOverride = priority > this.namePriority);
        if (shouldOverride && name != null && !name.isEmpty()) {
            this.name.setLength(0);
            this.name.append(name);
            this.namePriority = priority;
        }
        return this.thiz();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    @Override
    public void resetState() {
        this.finished = true;
        this.name.setLength(0);
        this.timestamp = 0L;
        this.duration = 0L;
        this.traceContext.resetState();
        this.childDurations.resetState();
        this.references.set(0);
        this.namePriority = 0;
        this.discardRequested = false;
        this.isExit = false;
        this.childIds = null;
    }

    public Span createSpan() {
        return this.createSpan(this.traceContext.getClock().getEpochMicros());
    }

    public Span createSpan(long epochMicros) {
        return this.tracer.startSpan(this, epochMicros);
    }

    @Nullable
    public Span createExitSpan() {
        if (this.isExit()) {
            return null;
        }
        return (Span)this.createSpan().asExit();
    }

    public T asExit() {
        this.isExit = true;
        return (T)this;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public void captureException(long epochMicros, Throwable t) {
        this.tracer.captureAndReportException(epochMicros, t, this);
    }

    public T captureException(@Nullable Throwable t) {
        if (t != null) {
            this.captureException(this.getTraceContext().getClock().getEpochMicros(), t);
        }
        return (T)this;
    }

    @Nullable
    public String captureExceptionAndGetErrorId(@Nullable Throwable t) {
        return this.tracer.captureAndReportException(this.getTraceContext().getClock().getEpochMicros(), t, this);
    }

    public void addLabel(String key, String value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public void addLabel(String key, Number value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public void addLabel(String key, Boolean value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public abstract AbstractContext getContext();

    protected void onAfterStart() {
        this.finished = false;
        this.incrementReferences();
    }

    public void end() {
        this.end(this.traceContext.getClock().getEpochMicros());
    }

    public final void end(long epochMicros) {
        if (!this.finished) {
            this.duration = epochMicros - this.timestamp;
            if (this.name.length() == 0) {
                this.name.append("unnamed");
            }
            this.childDurations.onSpanEnd(epochMicros);
            this.beforeEnd(epochMicros);
            this.finished = true;
            this.afterEnd();
        } else {
            logger.warn("End has already been called: {}", (Object)this);
            assert (false);
        }
    }

    protected abstract void beforeEnd(long var1);

    protected abstract void afterEnd();

    public boolean isChildOf(AbstractSpan<?> parent) {
        return this.traceContext.isChildOf(parent.traceContext) || super.hasChildId(this.traceContext.getId());
    }

    private boolean hasChildId(Id spanId) {
        if (this.childIds != null) {
            return this.childIds.contains(spanId.readLong(0));
        }
        return false;
    }

    public T activate() {
        this.tracer.activate(this);
        return (T)this;
    }

    public T deactivate() {
        this.tracer.deactivate(this);
        return (T)this;
    }

    public Scope activateInScope() {
        if (this.tracer.getActive() == this) {
            return Scope.NoopScope.INSTANCE;
        }
        this.activate();
        return new Scope(){

            @Override
            public void close() {
                AbstractSpan.this.deactivate();
            }
        };
    }

    public Runnable withActive(Runnable runnable) {
        return this.tracer.wrapRunnable(runnable, this);
    }

    public <V> Callable<V> withActive(Callable<V> callable) {
        return this.tracer.wrapCallable(callable, this);
    }

    public void setStartTimestamp(long epochMicros) {
        this.timestamp = epochMicros;
    }

    public void setStartTimestampNow() {
        this.timestamp = this.getTraceContext().getClock().getEpochMicros();
    }

    void onChildStart(long epochMicros) {
        if (this.collectBreakdownMetrics) {
            this.childDurations.onChildStart(epochMicros);
        }
    }

    void onChildEnd(long epochMicros) {
        if (this.collectBreakdownMetrics) {
            this.childDurations.onChildEnd(epochMicros);
        }
    }

    public void incrementReferences() {
        int referenceCount = this.references.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("increment references to {} ({})", (Object)this, (Object)referenceCount);
            if (logger.isTraceEnabled()) {
                logger.trace("incrementing references at", new RuntimeException("This is an expected exception. Is just used to record where the reference count has been incremented."));
            }
        }
    }

    public void decrementReferences() {
        int referenceCount = this.references.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("decrement references to {} ({})", (Object)this, (Object)referenceCount);
            if (logger.isTraceEnabled()) {
                logger.trace("decrementing references at", new RuntimeException("This is an expected exception. Is just used to record where the reference count has been decremented."));
            }
        }
        if (referenceCount == 0) {
            this.recycle();
        }
    }

    protected abstract void recycle();

    public <C> void propagateTraceContext(C carrier, TextHeaderSetter<C> headerSetter) {
        this.setNonDiscardable();
        this.getTraceContext().propagateTraceContext(carrier, headerSetter);
    }

    public <C> boolean propagateTraceContext(C carrier, BinaryHeaderSetter<C> headerSetter) {
        this.setNonDiscardable();
        return this.getTraceContext().propagateTraceContext(carrier, headerSetter);
    }

    public void setNonDiscardable() {
        this.getTraceContext().setNonDiscardable();
    }

    public boolean isDiscardable() {
        return this.getTraceContext().isDiscardable();
    }

    public boolean isSampled() {
        return this.getTraceContext().isSampled();
    }

    public T withChildIds(@Nullable LongList childIds) {
        this.childIds = childIds;
        return this.thiz();
    }

    @Nullable
    public LongList getChildIds() {
        return this.childIds;
    }

    protected abstract T thiz();

    private static class ChildDurationTimer
    implements Recyclable {
        private AtomicInteger activeChildren = new AtomicInteger();
        private AtomicLong start = new AtomicLong();
        private AtomicLong duration = new AtomicLong();

        private ChildDurationTimer() {
        }

        void onChildStart(long startTimestamp) {
            if (this.activeChildren.incrementAndGet() == 1) {
                this.start.set(startTimestamp);
            }
        }

        void onChildEnd(long endTimestamp) {
            if (this.activeChildren.decrementAndGet() == 0) {
                this.incrementDuration(endTimestamp);
            }
        }

        void onSpanEnd(long endTimestamp) {
            if (this.activeChildren.getAndSet(0) != 0) {
                this.incrementDuration(endTimestamp);
            }
        }

        private void incrementDuration(long epochMicros) {
            this.duration.addAndGet(epochMicros - this.start.get());
        }

        @Override
        public void resetState() {
            this.activeChildren.set(0);
            this.start.set(0L);
            this.duration.set(0L);
        }

        public long getDuration() {
            return this.duration.get();
        }
    }
}

