/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.Timer;
import co.elastic.apm.agent.shaded.HdrHistogram.WriterReaderPhaser;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.KeyListConcurrentHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class Transaction
extends AbstractSpan<Transaction> {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private static final ThreadLocal<Labels.Mutable> labelsThreadLocal = new ThreadLocal<Labels.Mutable>(){

        @Override
        protected Labels.Mutable initialValue() {
            return Labels.Mutable.of();
        }
    };
    public static final String TYPE_REQUEST = "request";
    private final TransactionContext context = new TransactionContext();
    private final SpanCount spanCount = new SpanCount();
    private final KeyListConcurrentHashMap<String, KeyListConcurrentHashMap<String, Timer>> timerBySpanTypeAndSubtype = new KeyListConcurrentHashMap();
    private final WriterReaderPhaser phaser = new WriterReaderPhaser();
    @Nullable
    private String result;
    private boolean noop;
    @Nullable
    private volatile String type;
    private int maxSpans;

    @Override
    public Transaction getTransaction() {
        return this;
    }

    public Transaction(ElasticApmTracer tracer) {
        super(tracer);
    }

    public <T> Transaction start(TraceContext.ChildContextCreator<T> childContextCreator, @Nullable T parent, long epochMicros, Sampler sampler, @Nullable ClassLoader initiatingClassLoader) {
        this.traceContext.setApplicationClassLoader(initiatingClassLoader);
        boolean startedAsChild = parent != null && childContextCreator.asChildOf(this.traceContext, parent);
        this.onTransactionStart(startedAsChild, epochMicros, sampler);
        return this;
    }

    public <T, A> Transaction start(TraceContext.ChildContextCreatorTwoArg<T, A> childContextCreator, @Nullable T parent, A arg, long epochMicros, Sampler sampler, @Nullable ClassLoader initiatingClassLoader) {
        this.traceContext.setApplicationClassLoader(initiatingClassLoader);
        boolean startedAsChild = childContextCreator.asChildOf(this.traceContext, parent, arg);
        this.onTransactionStart(startedAsChild, epochMicros, sampler);
        return this;
    }

    private void onTransactionStart(boolean startedAsChild, long epochMicros, Sampler sampler) {
        this.maxSpans = this.tracer.getConfig(CoreConfiguration.class).getTransactionMaxSpans();
        if (!startedAsChild) {
            this.traceContext.asRootSpan(sampler);
        }
        if (epochMicros >= 0L) {
            this.setStartTimestamp(epochMicros);
        } else {
            this.setStartTimestampNow();
        }
        this.onAfterStart();
    }

    public Transaction startNoop() {
        this.name.append("noop");
        this.noop = true;
        this.onAfterStart();
        return this;
    }

    @Override
    public TransactionContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getContextEnsureVisibility() {
        Transaction transaction = this;
        synchronized (transaction) {
            return this.context;
        }
    }

    public Transaction withType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    public Transaction withResultIfUnset(@Nullable String result) {
        if (this.result == null) {
            this.result = result;
        }
        return this;
    }

    public Transaction withResult(@Nullable String result) {
        this.result = result;
        return this;
    }

    public void setUser(String id, String email, String username) {
        if (!this.isSampled()) {
            return;
        }
        this.getContext().getUser().withId(id).withEmail(email).withUsername(username);
    }

    @Override
    public void beforeEnd(long epochMicros) {
        if (!this.isSampled()) {
            this.context.resetState();
        }
        if (this.type == null) {
            this.type = "custom";
        }
        this.context.onTransactionEnd();
        this.incrementTimer("app", null, this.getSelfDuration());
    }

    @Override
    protected void afterEnd() {
        this.trackMetrics();
        this.tracer.endTransaction(this);
    }

    public SpanCount getSpanCount() {
        return this.spanCount;
    }

    boolean isSpanLimitReached() {
        return this.getSpanCount().isSpanLimitReached(this.maxSpans);
    }

    public KeyListConcurrentHashMap<String, KeyListConcurrentHashMap<String, Timer>> getTimerBySpanTypeAndSubtype() {
        return this.timerBySpanTypeAndSubtype;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.result = null;
        this.spanCount.resetState();
        this.type = null;
        this.noop = false;
        this.maxSpans = 0;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void ignoreTransaction() {
        this.noop = true;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void addCustomContext(String key, String value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public void addCustomContext(String key, Number value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public void addCustomContext(String key, Boolean value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public String toString() {
        return String.format("'%s' %s (%s)", this.name, this.traceContext, Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public void incrementReferences() {
        super.incrementReferences();
    }

    @Override
    protected void recycle() {
        this.tracer.recycle(this);
    }

    @Override
    protected Transaction thiz() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementTimer(@Nullable String type, @Nullable String subtype, long duration) {
        long criticalValueAtEnter = this.phaser.writerCriticalSectionEnter();
        try {
            Timer racyTimer;
            Timer timer;
            KeyListConcurrentHashMap racyMap;
            KeyListConcurrentHashMap<String, Timer> timersBySubtype;
            if (!this.collectBreakdownMetrics || type == null || this.finished) {
                return;
            }
            if (subtype == null) {
                subtype = "";
            }
            if ((timersBySubtype = (KeyListConcurrentHashMap<String, Timer>)this.timerBySpanTypeAndSubtype.get(type)) == null && (racyMap = this.timerBySpanTypeAndSubtype.putIfAbsent(type, timersBySubtype = new KeyListConcurrentHashMap<String, Timer>())) != null) {
                timersBySubtype = racyMap;
            }
            if ((timer = (Timer)timersBySubtype.get(subtype)) == null && (racyTimer = timersBySubtype.putIfAbsent(subtype, timer = new Timer())) != null) {
                timer = racyTimer;
            }
            timer.update(duration);
            if (this.finished) {
                timer.resetState();
            }
        }
        finally {
            this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackMetrics() {
        try {
            this.phaser.readerLock();
            this.phaser.flipPhase();
            String type = this.getType();
            if (type == null) {
                return;
            }
            Labels.Mutable labels = labelsThreadLocal.get();
            labels.resetState();
            labels.transactionName(this.name).transactionType(type);
            MetricRegistry metricRegistry = this.tracer.getMetricRegistry();
            long criticalValueAtEnter = metricRegistry.writerCriticalSectionEnter();
            try {
                metricRegistry.updateTimer("transaction.duration", labels, this.getDuration());
                if (this.collectBreakdownMetrics) {
                    metricRegistry.incrementCounter("transaction.breakdown.count", labels);
                    List<String> types = this.timerBySpanTypeAndSubtype.keyList();
                    for (int i = 0; i < types.size(); ++i) {
                        String spanType = types.get(i);
                        KeyListConcurrentHashMap timerBySubtype = (KeyListConcurrentHashMap)this.timerBySpanTypeAndSubtype.get(spanType);
                        List subtypes = timerBySubtype.keyList();
                        for (int j = 0; j < subtypes.size(); ++j) {
                            String subtype = (String)subtypes.get(j);
                            Timer timer = (Timer)timerBySubtype.get(subtype);
                            if (timer.getCount() <= 0L) continue;
                            if (subtype.equals("")) {
                                subtype = null;
                            }
                            labels.spanType(spanType).spanSubType(subtype);
                            metricRegistry.updateTimer("span.self_time", labels, timer.getTotalTimeUs(), timer.getCount());
                            timer.resetState();
                        }
                    }
                }
            }
            finally {
                metricRegistry.writerCriticalSectionExit(criticalValueAtEnter);
            }
        }
        finally {
            this.phaser.readerUnlock();
        }
    }
}

