/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jaxrs;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jaxrs.JaxRsConfiguration;
import co.elastic.apm.agent.jaxrs.JaxRsOffsetMappingFactory;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class JaxRsTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    public static boolean useAnnotationValueForTransactionName;
    private final Collection<String> applicationPackages;
    private final JaxRsConfiguration configuration;

    public JaxRsTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
        this.configuration = tracer.getConfig(JaxRsConfiguration.class);
        useAnnotationValueForTransactionName = this.configuration.isUseJaxRsPathForTransactionName();
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @JaxRsOffsetMappingFactory.JaxRsPath @Nullable String pathAnnotationValue) {
        Transaction transaction;
        if (tracer != null && (transaction = tracer.currentTransaction()) != null) {
            String transactionName = signature;
            if (useAnnotationValueForTransactionName && pathAnnotationValue != null) {
                transactionName = pathAnnotationValue;
            }
            transaction.withName(transactionName, 100, false);
        }
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any());
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        if (this.configuration.isEnableJaxrsAnnotationInheritance()) {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.ws.rs.Path")).or(ElementMatchers.hasSuperType(ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.ws.rs.Path")))));
        }
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.ws.rs.Path"));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.ws.rs.Path"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.ws.rs.GET").or(ElementMatchers.named("javax.ws.rs.POST")).or(ElementMatchers.named("javax.ws.rs.PUT")).or(ElementMatchers.named("javax.ws.rs.DELETE")).or(ElementMatchers.named("javax.ws.rs.HEAD")).or(ElementMatchers.named("javax.ws.rs.OPTIONS")))).onSuperClassesThat(CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("jax-rs");
    }

    @Override
    @Nullable
    public Advice.OffsetMapping.Factory<?> getOffsetMapping() {
        return new JaxRsOffsetMappingFactory(tracer);
    }
}

