/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.helper.ConnectionMetaData;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.jdbc.signature.SignatureParser;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DataStructures;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;

public class JdbcHelperImpl
extends JdbcHelper {
    private static final Logger logger = LoggerFactory.getLogger(JdbcHelperImpl.class);
    private final WeakConcurrentMap<Connection, ConnectionMetaData> metaDataMap = DataStructures.createWeakConcurrentMapWithCleanerThread();
    private final WeakConcurrentMap<Class<?>, Boolean> metadataSupported = new WeakConcurrentMap.WithInlinedExpunction();
    private final WeakConcurrentMap<Class<?>, Boolean> connectionSupported = new WeakConcurrentMap.WithInlinedExpunction();
    public final ThreadLocal<SignatureParser> SIGNATURE_PARSER_THREAD_LOCAL = new ThreadLocal<SignatureParser>(){

        @Override
        protected SignatureParser initialValue() {
            return new SignatureParser();
        }
    };

    @Override
    public void clearInternalStorage() {
        this.metaDataMap.clear();
        this.metadataSupported.clear();
        this.connectionSupported.clear();
    }

    @Override
    @Nullable
    public Span createJdbcSpan(@Nullable String sql, Object statement, @Nullable AbstractSpan<?> parent, boolean preparedStatement) {
        ConnectionMetaData connectionMetaData;
        StringBuilder spanName;
        if (!(statement instanceof Statement) || sql == null || this.isAlreadyMonitored(parent) || parent == null) {
            return null;
        }
        Span span = (Span)parent.createSpan().activate();
        if (sql.isEmpty()) {
            span.withName("empty query");
        } else if (span.isSampled() && (spanName = span.getAndOverrideName(0)) != null) {
            this.SIGNATURE_PARSER_THREAD_LOCAL.get().querySignature(sql, spanName, preparedStatement);
        }
        span.withType("db");
        span.getContext().getDb().withStatement(sql.isEmpty() ? "(empty query)" : sql).withType("sql");
        Connection connection = this.safeGetConnection((Statement)statement);
        ConnectionMetaData connectionMetaData2 = connectionMetaData = connection == null ? null : this.getConnectionMetaData(connection);
        if (connectionMetaData != null) {
            span.withSubtype(connectionMetaData.getDbVendor()).withAction("query");
            span.getContext().getDb().withUser(connectionMetaData.getUser());
            Destination destination = span.getContext().getDestination().withAddress(connectionMetaData.getHost()).withPort(connectionMetaData.getPort());
            destination.getService().withName(connectionMetaData.getDbVendor()).withResource(connectionMetaData.getDbVendor()).withType("db");
        }
        return span;
    }

    private boolean isAlreadyMonitored(@Nullable AbstractSpan<?> parent) {
        if (!(parent instanceof Span)) {
            return false;
        }
        Span parentSpan = (Span)parent;
        return parentSpan.getType() != null && parentSpan.getType().equals("db");
    }

    @Nullable
    private ConnectionMetaData getConnectionMetaData(Connection connection) {
        ConnectionMetaData connectionMetaData = this.metaDataMap.get(connection);
        if (connectionMetaData != null) {
            return connectionMetaData;
        }
        Class<?> type = connection.getClass();
        Boolean supported = JdbcHelperImpl.isSupported(this.metadataSupported, type);
        if (supported == Boolean.FALSE) {
            return null;
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            connectionMetaData = ConnectionMetaData.create(metaData.getURL(), metaData.getUserName());
            if (supported == null) {
                JdbcHelperImpl.markSupported(this.metadataSupported, type);
            }
        }
        catch (SQLException e) {
            JdbcHelperImpl.markNotSupported(this.metadataSupported, type, e);
        }
        if (connectionMetaData != null) {
            this.metaDataMap.put(connection, connectionMetaData);
        }
        return connectionMetaData;
    }

    @Nullable
    private Connection safeGetConnection(Statement statement) {
        Connection connection = null;
        Class<?> type = statement.getClass();
        Boolean supported = JdbcHelperImpl.isSupported(this.connectionSupported, type);
        if (supported == Boolean.FALSE) {
            return null;
        }
        try {
            connection = statement.getConnection();
            if (supported == null) {
                JdbcHelperImpl.markSupported(this.connectionSupported, type);
            }
        }
        catch (SQLException e) {
            JdbcHelperImpl.markNotSupported(this.connectionSupported, type, e);
        }
        return connection;
    }

    @Nullable
    private static Boolean isSupported(WeakConcurrentMap<Class<?>, Boolean> featureMap, Class<?> type) {
        return featureMap.get(type);
    }

    private static void markSupported(WeakConcurrentMap<Class<?>, Boolean> map, Class<?> type) {
        map.put(type, Boolean.TRUE);
    }

    private static void markNotSupported(WeakConcurrentMap<Class<?>, Boolean> map, Class<?> type, SQLException e) {
        Boolean previous = map.put(type, Boolean.FALSE);
        if (previous == null) {
            logger.warn("JDBC feature not supported on class " + type, e);
        }
    }
}

