/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.signature;

import co.elastic.apm.agent.jdbc.signature.Scanner;

class JdbcFilter {
    private boolean inQuote = false;
    private boolean inJdbcEscape = false;
    private boolean jdbcKeyWord = false;

    JdbcFilter() {
    }

    boolean skip(Scanner s, char c) {
        switch (c) {
            case '{': {
                if (this.inQuote) break;
                this.inJdbcEscape = true;
                this.jdbcKeyWord = true;
                return true;
            }
            case 'O': 
            case 'o': {
                if (this.inQuote || !this.inJdbcEscape || !this.jdbcKeyWord || !s.isNextCharIgnoreCase('j')) break;
                s.next();
                this.jdbcKeyWord = false;
                return true;
            }
            case '}': {
                if (this.inQuote) break;
                this.inJdbcEscape = false;
                return true;
            }
            case '=': 
            case '?': {
                if (this.inQuote || !this.inJdbcEscape) break;
                return true;
            }
            case '\'': {
                this.inQuote = !this.inQuote;
            }
        }
        this.jdbcKeyWord = false;
        return false;
    }

    void reset() {
        this.inQuote = false;
        this.inJdbcEscape = false;
        this.jdbcKeyWord = false;
    }
}

