/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jsf;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public abstract class JsfLifecycleInstrumentation
extends ElasticApmInstrumentation {
    private static final String SPAN_TYPE = "template";
    private static final String SPAN_SUBTYPE = "jsf";

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Lifecycle");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.faces.lifecycle.Lifecycle"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("javax.faces.lifecycle.Lifecycle"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", SPAN_SUBTYPE);
    }

    public static class JsfLifecycleRenderInstrumentation
    extends JsfLifecycleInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("render").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.faces.context.FacesContext")));
        }

        @Override
        public Collection<String> getInstrumentationGroupNames() {
            ArrayList<String> ret = new ArrayList<String>(super.getInstrumentationGroupNames());
            ret.add("render");
            return ret;
        }

        @Override
        public Class<?> getAdviceClass() {
            return JsfLifecycleRenderAdvice.class;
        }

        public static class JsfLifecycleRenderAdvice {
            private static final String SPAN_ACTION = "render";

            @Advice.OnMethodEnter(suppress=Throwable.class)
            public static void createRenderSpan(@Advice.Local(value="span") Span span) {
                if (ElasticApmInstrumentation.tracer != null) {
                    Span parentSpan;
                    AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
                    if (parent == null) {
                        return;
                    }
                    if (parent instanceof Span && JsfLifecycleInstrumentation.SPAN_SUBTYPE.equals((parentSpan = (Span)parent).getSubtype()) && SPAN_ACTION.equals(parentSpan.getAction())) {
                        return;
                    }
                    span = (Span)parent.createSpan().withType(JsfLifecycleInstrumentation.SPAN_TYPE).withSubtype(JsfLifecycleInstrumentation.SPAN_SUBTYPE).withAction(SPAN_ACTION).withName("JSF Render");
                    span.activate();
                }
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
            public static void endRenderSpan(@Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
                if (span != null) {
                    try {
                        if (t != null) {
                            span.captureException(t);
                        }
                    }
                    finally {
                        ((Span)span.deactivate()).end();
                    }
                }
            }
        }
    }

    public static class JsfLifecycleExecuteInstrumentation
    extends JsfLifecycleInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.faces.context.FacesContext")));
        }

        @Override
        public Class<?> getAdviceClass() {
            return JsfLifecycleExecuteAdvice.class;
        }

        public static class JsfLifecycleExecuteAdvice {
            private static final String SPAN_ACTION = "execute";

            @Advice.OnMethodEnter(suppress=Throwable.class)
            public static void createExecuteSpan(@Advice.Argument(value=0) FacesContext facesContext, @Advice.Local(value="span") Span span) {
                if (ElasticApmInstrumentation.tracer != null) {
                    Span parentSpan;
                    AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
                    if (parent == null) {
                        return;
                    }
                    if (parent instanceof Span && JsfLifecycleInstrumentation.SPAN_SUBTYPE.equals((parentSpan = (Span)parent).getSubtype()) && SPAN_ACTION.equals(parentSpan.getAction())) {
                        return;
                    }
                    Transaction transaction = ElasticApmInstrumentation.tracer.currentTransaction();
                    if (transaction != null) {
                        try {
                            ExternalContext externalContext = facesContext.getExternalContext();
                            if (externalContext != null) {
                                transaction.withName(externalContext.getRequestServletPath(), 100);
                                String pathInfo = externalContext.getRequestPathInfo();
                                if (pathInfo != null) {
                                    transaction.appendToName(pathInfo, 100);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    span = (Span)parent.createSpan().withType(JsfLifecycleInstrumentation.SPAN_TYPE).withSubtype(JsfLifecycleInstrumentation.SPAN_SUBTYPE).withAction(SPAN_ACTION).withName("JSF Execute");
                    span.activate();
                }
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
            public static void endExecuteSpan(@Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
                if (span != null) {
                    try {
                        if (t != null) {
                            span.captureException(t);
                        }
                    }
                    finally {
                        ((Span)span.deactivate()).end();
                    }
                }
            }
        }
    }
}

