/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.logging.LogLevel;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoggingConfiguration
extends ConfigurationOptionProvider {
    private static final String SYSTEM_OUT = "System.out";
    private static final String LOG_LEVEL_KEY = "log_level";
    private static final String LOG_FILE_KEY = "log_file";
    private static final String DEFAULT_LOG_FILE = "System.out";
    private static final String LOGGING_CATEGORY = "Logging";
    public static final String AGENT_HOME_PLACEHOLDER = "_AGENT_HOME_";
    private static final String DEPRECATED_LOG_LEVEL_KEY = "logging.log_level";
    private static final String DEPRECATED_LOG_FILE_KEY = "logging.log_file";
    public ConfigurationOption<LogLevel> logLevel = ConfigurationOption.enumOption(LogLevel.class).key("log_level").aliasKeys("logging.log_level").configurationCategory("Logging").description("Sets the logging level for the agent.\n\nThis option is case-insensitive.").dynamic(true).addChangeListener(new ConfigurationOption.ChangeListener<LogLevel>(){

        @Override
        public void onChange(ConfigurationOption<?> configurationOption, LogLevel oldValue, LogLevel newValue) {
            LoggingConfiguration.setLogLevel(newValue.toString());
        }
    }).buildWithDefault(LogLevel.INFO);
    public ConfigurationOption<String> logFile = ConfigurationOption.stringOption().key("log_file").aliasKeys("logging.log_file").configurationCategory("Logging").description("Sets the path of the agent logs.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the elastic-apm-agent.jar is in.\nExample: `_AGENT_HOME_/logs/elastic-apm.log`\n\nWhen set to the special value 'System.out',\nthe logs are sent to standard out.\n\nNOTE: When logging to a file,\nit's content is deleted when the application starts.").dynamic(false).buildWithDefault("System.out");
    private final ConfigurationOption<Boolean> logCorrelationEnabled = ConfigurationOption.booleanOption().key("enable_log_correlation").configurationCategory("Logging").description("A boolean specifying if the agent should integrate into SLF4J's https://www.slf4j.org/api/org/slf4j/MDC.html[MDC] to enable trace-log correlation.\nIf set to `true`, the agent will set the `trace.id` and `transaction.id` for the currently active spans and transactions to the MDC.\nSince version 1.16.0, the agent also adds `error.id` of captured error to the MDC just before the error message is logged.\nSee <<log-correlation>> for more details.\n\nNOTE: While it's allowed to enable this setting at runtime, you can't disable it without a restart.").dynamic(true).addValidator(new ConfigurationOption.Validator<Boolean>(){

        @Override
        public void assertValid(Boolean value) {
            if (LoggingConfiguration.this.logCorrelationEnabled != null && LoggingConfiguration.this.isLogCorrelationEnabled() && Boolean.FALSE.equals(value)) {
                throw new IllegalArgumentException("Disabling the log correlation at runtime is not possible.");
            }
        }
    }).buildWithDefault(false);

    public static void init(List<ConfigurationSource> sources) {
        LoggingConfiguration.setLogLevel(LoggingConfiguration.getValue(LOG_LEVEL_KEY, sources, LoggingConfiguration.getValue(DEPRECATED_LOG_LEVEL_KEY, sources, LogLevel.INFO.toString())));
        LoggingConfiguration.setLogFileLocation(ElasticApmAgent.getAgentHome(), LoggingConfiguration.getValue(LOG_FILE_KEY, sources, LoggingConfiguration.getValue(DEPRECATED_LOG_FILE_KEY, sources, "System.out")));
    }

    private static String getValue(String key, List<ConfigurationSource> sources, String defaultValue) {
        for (ConfigurationSource source : sources) {
            String value = source.getValue(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    private static void setLogLevel(@Nullable String level) {
        System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.log.co.elastic.apm", level != null ? level : LogLevel.INFO.toString());
        System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.log.co.elastic.apm.agent.shaded", LogLevel.OFF.toString().equals(level) ? level : LogLevel.WARN.toString());
        System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.showDateTime", Boolean.TRUE.toString());
        System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.dateTimeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static void setLogFileLocation(@Nullable String agentHome, String logFile) {
        if ("System.out".equalsIgnoreCase(logFile)) {
            System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.logFile", "System.out");
        } else {
            System.setProperty("co.elastic.apm.agent.shaded.slf4j.simpleLogger.logFile", LoggingConfiguration.getActualLogFile(agentHome, logFile));
        }
    }

    @Nonnull
    static String getActualLogFile(@Nullable String agentHome, String logFile) {
        File logDir;
        if (logFile.contains(AGENT_HOME_PLACEHOLDER)) {
            if (agentHome == null) {
                System.err.println("Could not resolve _AGENT_HOME_. Falling back to System.out.");
                return "System.out";
            }
            logFile = logFile.replace(AGENT_HOME_PLACEHOLDER, agentHome);
        }
        if (!(logDir = new File(logFile = new File(logFile).getAbsolutePath()).getParentFile()).exists()) {
            logDir.mkdir();
        }
        if (!logDir.canWrite()) {
            System.err.println("Log file " + logFile + " is not writable. Falling back to System.out.");
            return "System.out";
        }
        System.out.println("Writing Elastic APM logs to " + logFile);
        return logFile;
    }

    public boolean isLogCorrelationEnabled() {
        return this.logCorrelationEnabled.get();
    }
}

