/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import com.sun.management.ThreadMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class JvmGcMetrics
extends AbstractLifecycleListener {
    private final List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();

    @Override
    public void start(ElasticApmTracer tracer) {
        this.bindTo(tracer.getMetricRegistry());
    }

    void bindTo(MetricRegistry registry) {
        for (final GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            Labels.Mutable tags = Labels.Mutable.of("name", garbageCollectorMXBean.getName());
            registry.addUnlessNegative("jvm.gc.count", tags, new DoubleSupplier(){

                @Override
                public double get() {
                    return garbageCollectorMXBean.getCollectionCount();
                }
            });
            registry.addUnlessNegative("jvm.gc.time", tags, new DoubleSupplier(){

                @Override
                public double get() {
                    return garbageCollectorMXBean.getCollectionTime();
                }
            });
        }
        try {
            Class<?> sunBeanClass = Class.forName("com.sun.management.ThreadMXBean");
            if (sunBeanClass.isInstance(ManagementFactory.getThreadMXBean())) {
                registry.add("jvm.gc.alloc", Labels.EMPTY, (DoubleSupplier)Class.forName(this.getClass().getName() + "$HotspotAllocationSupplier").getEnumConstants()[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @IgnoreJRERequirement
    static enum HotspotAllocationSupplier implements DoubleSupplier
    {
        INSTANCE;

        final ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();

        @Override
        public double get() {
            long allocatedBytes = 0L;
            for (long threadAllocatedBytes : this.threadMXBean.getThreadAllocatedBytes(this.threadMXBean.getAllThreadIds())) {
                if (threadAllocatedBytes <= 0L) continue;
                allocatedBytes += threadAllocatedBytes;
            }
            return allocatedBytes;
        }
    }
}

