/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.Resetter;
import co.elastic.apm.agent.objectpool.impl.AbstractObjectPool;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ListBasedObjectPool<T>
extends AbstractObjectPool<T> {
    private final List<T> pool;
    private final int limit;

    public static <T extends Recyclable> ListBasedObjectPool<T> ofRecyclable(int limit, Allocator<T> allocator) {
        return ListBasedObjectPool.ofRecyclable(new ArrayList(), limit, allocator);
    }

    public static <T extends Recyclable> ListBasedObjectPool<T> ofRecyclable(List<T> list, int limit, Allocator<T> allocator) {
        return new ListBasedObjectPool<T>(list, limit, allocator, Resetter.ForRecyclable.get());
    }

    public ListBasedObjectPool(List<T> pool, int limit, Allocator<T> allocator, Resetter<T> resetter) {
        super(allocator, resetter);
        this.pool = pool;
        this.limit = limit;
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        if (!this.pool.isEmpty()) {
            return this.pool.remove(this.pool.size() - 1);
        }
        return null;
    }

    @Override
    protected boolean returnToPool(T obj) {
        if (this.pool.size() < this.limit) {
            this.pool.add(obj);
            return true;
        }
        return false;
    }

    @Override
    public int getObjectsInPool() {
        return this.pool.size();
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

