/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import javax.annotation.Nullable;

public class OkHttpClientHelper {
    private static final ThreadLocal<StringBuilder> destinationHostName = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    @Nullable
    public static CharSequence computeHostName(@Nullable String originalHostName) {
        CharSequence hostName = originalHostName;
        if (originalHostName != null && originalHostName.contains(":") && !originalHostName.startsWith("[")) {
            StringBuilder sb = destinationHostName.get();
            sb.setLength(0);
            sb.append("[").append(originalHostName).append("]");
            hostName = sb;
        }
        return hostName;
    }
}

