/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Map;
import javax.annotation.Nullable;

public class ApmSpanInstrumentation
extends OpenTracingBridgeInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(ApmSpanInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpan");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class GetTraceContextInstrumentation
    extends ApmSpanInstrumentation {
        public GetTraceContextInstrumentation() {
            super(ElementMatchers.named("getTraceContext"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void getTraceContext(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> abstractSpan, @Advice.Return(readOnly=false) Object traceContext) {
            if (abstractSpan != null) {
                traceContext = abstractSpan;
            }
        }
    }

    public static class TagInstrumentation
    extends ApmSpanInstrumentation {
        public TagInstrumentation() {
            super(ElementMatchers.named("handleTag"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void handleTag(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> span, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Object value) {
            if (value == null) {
                return;
            }
            if (span instanceof Transaction) {
                TagInstrumentation.handleTransactionTag((Transaction)span, key, value);
            } else if (span instanceof Span) {
                TagInstrumentation.handleSpanTag((Span)span, key, value);
            } else {
                logger.warn("Calling setTag on an already finished span");
            }
        }

        private static void handleTransactionTag(Transaction transaction, String key, Object value) {
            if (!TagInstrumentation.handleSpecialTransactionTag(transaction, key, value)) {
                TagInstrumentation.addTag(transaction, key, value);
            }
        }

        private static void handleSpanTag(Span span, String key, Object value) {
            if (!TagInstrumentation.handleSpecialSpanTag(span, key, value)) {
                TagInstrumentation.addTag(span, key, value);
            }
        }

        private static void addTag(AbstractSpan transaction, String key, Object value) {
            if (value instanceof Number) {
                transaction.addLabel(key, (Number)value);
            } else if (value instanceof Boolean) {
                transaction.addLabel(key, (Boolean)value);
            } else {
                transaction.addLabel(key, value.toString());
            }
        }

        private static boolean handleSpecialTransactionTag(Transaction transaction, String key, Object value) {
            if ("type".equals(key)) {
                transaction.withType(value.toString());
                return true;
            }
            if ("result".equals(key)) {
                transaction.withResult(value.toString());
                return true;
            }
            if ("error".equals(key)) {
                if (Boolean.TRUE.equals(value)) {
                    transaction.withResultIfUnset("error");
                }
                return true;
            }
            if ("http.status_code".equals(key) && value instanceof Number) {
                transaction.getContext().getResponse().withStatusCode(((Number)value).intValue());
                transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(((Number)value).intValue()));
                transaction.withType("request");
                return true;
            }
            if ("http.method".equals(key)) {
                transaction.getContext().getRequest().withMethod(value.toString());
                transaction.withType("request");
                return true;
            }
            if ("http.url".equals(key)) {
                transaction.getContext().getRequest().getUrl().appendToFull(value.toString());
                transaction.withType("request");
                return true;
            }
            if ("sampling.priority".equals(key)) {
                return true;
            }
            if ("user.id".equals(key)) {
                transaction.getContext().getUser().withId(value.toString());
                return true;
            }
            if ("user.email".equals(key)) {
                transaction.getContext().getUser().withEmail(value.toString());
                return true;
            }
            if ("user.username".equals(key)) {
                transaction.getContext().getUser().withUsername(value.toString());
                return true;
            }
            return false;
        }

        private static boolean handleSpecialSpanTag(Span span, String key, Object value) {
            if ("type".equals(key)) {
                if (span.getSubtype() == null && span.getAction() == null) {
                    span.setType(value.toString(), null, null);
                } else {
                    span.withType(value.toString());
                }
                return true;
            }
            if ("subtype".equals(key)) {
                span.withSubtype(value.toString());
                return true;
            }
            if ("action".equals(key)) {
                span.withAction(value.toString());
                return true;
            }
            if ("sampling.priority".equals(key)) {
                return true;
            }
            if ("db.type".equals(key)) {
                span.getContext().getDb().withType(value.toString());
                if (TagInstrumentation.isCache(value)) {
                    span.withType("cache").withSubtype(value.toString());
                } else {
                    span.withType("db").withSubtype(value.toString());
                }
                return true;
            }
            if ("db.instance".equals(key)) {
                span.getContext().getDb().withInstance(value.toString());
                return true;
            }
            if ("db.statement".equals(key)) {
                span.getContext().getDb().withStatement(value.toString());
                span.withAction("query");
                return true;
            }
            if ("span.kind".equals(key)) {
                if (span.getType() == null && ("producer".equals(value) || "client".equals(value))) {
                    span.withType("ext");
                }
                return true;
            }
            return false;
        }

        private static boolean isCache(Object dbType) {
            return "redis".equals(dbType);
        }
    }

    public static class LogInstrumentation
    extends ApmSpanInstrumentation {
        public LogInstrumentation() {
            super(ElementMatchers.named("log").and(ElementMatchers.takesArguments(Long.TYPE, Map.class)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void log(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> span, @Advice.Argument(value=0) long epochTimestampMicros, @Advice.Argument(value=1) Map<String, ?> fields) {
            if (span != null) {
                Object errorObject;
                if ("error".equals(fields.get("event")) && (errorObject = fields.get("error.object")) instanceof Throwable) {
                    if (epochTimestampMicros > 0L) {
                        span.captureException(epochTimestampMicros, (Throwable)errorObject);
                    } else {
                        span.captureException((Throwable)errorObject);
                    }
                }
            } else {
                logger.warn("Calling log on an already finished span");
            }
        }
    }

    public static class SetOperationName
    extends ApmSpanInstrumentation {
        public SetOperationName() {
            super(ElementMatchers.named("setOperationName"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void setOperationName(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> span, @Advice.Argument(value=0) @Nullable String operationName) {
            if (span != null) {
                span.withName(operationName, 1000);
            } else {
                logger.warn("Calling setOperationName on an already finished span");
            }
        }
    }

    public static class FinishInstrumentation
    extends ApmSpanInstrumentation {
        public FinishInstrumentation() {
            super(ElementMatchers.named("finishInternal"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void finishInternal(@Advice.FieldValue(value="dispatcher", readOnly=false, typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> span, @Advice.Argument(value=0) long finishMicros) {
            if (span != null) {
                FinishInstrumentation.doFinishInternal(span, finishMicros);
            }
        }

        public static void doFinishInternal(AbstractSpan<?> abstractSpan, long finishMicros) {
            abstractSpan.incrementReferences();
            if (abstractSpan instanceof Transaction) {
                Transaction transaction = (Transaction)abstractSpan;
                if (transaction.getType() == null) {
                    if (transaction.getContext().getRequest().hasContent()) {
                        transaction.withType("request");
                    } else {
                        transaction.withType("unknown");
                    }
                }
            } else {
                Span span = (Span)abstractSpan;
                if (span.getType() == null) {
                    span.withType("unknown");
                }
            }
            if (finishMicros >= 0L) {
                abstractSpan.end(finishMicros);
            } else {
                abstractSpan.end();
            }
        }
    }
}

