/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler.collections;

import co.elastic.apm.agent.profiler.collections.CollectionUtil;
import co.elastic.apm.agent.profiler.collections.Hashing;
import co.elastic.apm.agent.profiler.collections.LongLongConsumer;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Long2LongHashMap
implements Map<Long, Long>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private long[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Long2LongHashMap(long missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Long2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Long2LongHashMap(int initialCapacity, float loadFactor, long missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(CollectionUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 2;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(long key) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long value = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public long put(long key, long value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long[] oldEntries = this.entries;
        long missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        long[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            long value = oldEntries[keyIndex + 1];
            if (value == missingValue) continue;
            long key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (newEntries[index + 1] != missingValue) {
                index = Long2LongHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    public void longForEach(LongLongConsumer consumer) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int length = entries.length;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (entries[keyIndex + 1] == missingValue) continue;
            consumer.accept(entries[keyIndex], entries[keyIndex + 1]);
        }
    }

    public boolean containsKey(long key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(long value) {
        boolean found = false;
        if (value != this.missingValue) {
            long[] entries = this.entries;
            int length = entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (value != entries[valueIndex]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(CollectionUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public Long get(Object key) {
        return this.valOrNull(this.get((Long)key));
    }

    @Override
    public Long put(Long key, Long value) {
        return this.valOrNull(this.put((long)key, (long)value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        for (Map.Entry<? extends Long, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Long remove(Object key) {
        return this.valOrNull(this.remove((Long)key));
    }

    public long remove(long key) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while (entries[keyIndex + 1] != missingValue) {
            if (entries[keyIndex] == key) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Long2LongHashMap.next(keyIndex, mask)) + 1] != missingValue) {
            int hash = Hashing.evenHash(entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public long minValue() {
        long missingValue = this.missingValue;
        long min = this.size == 0 ? missingValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public long maxValue() {
        long missingValue = this.missingValue;
        long max = this.size == 0 ? missingValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getLongKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public long replace(long key, long value) {
        long currentValue = this.get(key);
        if (currentValue != this.missingValue) {
            currentValue = this.put(key, value);
        }
        return currentValue;
    }

    @Override
    public boolean replace(long key, long oldValue, long newValue) {
        long curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Long valOrNull(long value) {
        return value == this.missingValue ? null : Long.valueOf(value);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, Long>>
    implements Serializable {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Long value = Long2LongHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends AbstractSet<Long>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsKey(key);
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Long, Long>>,
    Map.Entry<Long, Long> {
        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        public long getLongValue() {
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Long setValue(Long value) {
            return this.setValue((long)value);
        }

        @Override
        public long setValue(long value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Long2LongHashMap.this.missingValue == value) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            long prevValue = Long2LongHashMap.this.entries[keyPosition + 1];
            ((Long2LongHashMap)Long2LongHashMap.this).entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Long, Long> next() {
            this.findNext();
            if (Long2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Long, Long> allocateDuplicateEntry() {
            final long k = this.getLongKey();
            final long v = this.getLongValue();
            return new Map.Entry<Long, Long>(){

                @Override
                public Long getKey() {
                    return k;
                }

                @Override
                public Long getValue() {
                    return v;
                }

                @Override
                public Long setValue(Long value) {
                    return Long2LongHashMap.this.put(k, (long)value);
                }

                @Override
                public int hashCode() {
                    return Hashing.hashCode(EntryIterator.this.getLongKey()) ^ Hashing.hashCode(EntryIterator.this.getLongValue());
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return e.getKey() != null && e.getValue() != null && e.getKey().equals(k) && e.getValue().equals(v);
                }

                public String toString() {
                    return k + "=" + v;
                }
            };
        }

        @Override
        public int hashCode() {
            return Hashing.hashCode(this.getLongKey()) ^ Hashing.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator
    implements Serializable {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Long2LongHashMap.this.size;
            long missingValue = Long2LongHashMap.this.missingValue;
            long[] entries = Long2LongHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != missingValue) {
                for (keyIndex = 0; keyIndex < capacity && entries[keyIndex + 1] != missingValue; keyIndex += 2) {
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Long2LongHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] entries = Long2LongHashMap.this.entries;
            long missingValue = Long2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Long2LongHashMap)Long2LongHashMap.this).entries[position + 1] = Long2LongHashMap.this.missingValue;
            --Long2LongHashMap.this.size;
            Long2LongHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

