/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.lettuce;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import co.elastic.apm.agent.redis.lettuce.Lettuce34Instrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import com.lambdaworks.redis.protocol.RedisCommand;
import javax.annotation.Nullable;

public class Lettuce34StartSpanInstrumentation
extends Lettuce34Instrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.lambdaworks.redis.RedisChannelHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("dispatch").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.not(ElementMatchers.isPrivate()));
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void beforeDispatch(@Nullable @Advice.Argument(value=0) RedisCommand command, @Advice.Local(value="span") Span span) throws Exception {
        if (command != null && (span = RedisSpanUtils.createRedisSpan(command.getType().toString())) != null) {
            commandToSpan.put(command, span);
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    private static void afterDispatch(@Nullable @Advice.Local(value="span") Span span) {
        if (span != null) {
            span.deactivate();
        }
    }
}

