/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReportingEvent;
import co.elastic.apm.agent.report.ReportingEventHandler;
import co.elastic.apm.agent.report.disruptor.ExponentionallyIncreasingSleepingWaitStrategy;
import co.elastic.apm.agent.shaded.lmax.disruptor.EventFactory;
import co.elastic.apm.agent.shaded.lmax.disruptor.EventTranslator;
import co.elastic.apm.agent.shaded.lmax.disruptor.EventTranslatorOneArg;
import co.elastic.apm.agent.shaded.lmax.disruptor.IgnoreExceptionHandler;
import co.elastic.apm.agent.shaded.lmax.disruptor.WaitStrategy;
import co.elastic.apm.agent.shaded.lmax.disruptor.dsl.Disruptor;
import co.elastic.apm.agent.shaded.lmax.disruptor.dsl.ProducerType;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.MathUtils;
import co.elastic.apm.agent.util.ThreadUtils;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class ApmServerReporter
implements Reporter {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerReporter.class);
    private static final EventTranslatorOneArg<ReportingEvent, Transaction> TRANSACTION_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Transaction>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Transaction t) {
            event.setTransaction(t);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Span> SPAN_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Span>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Span s) {
            event.setSpan(s);
        }
    };
    private static final EventTranslator<ReportingEvent> FLUSH_EVENT_TRANSLATOR = new EventTranslator<ReportingEvent>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence) {
            event.setFlushEvent();
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, ErrorCapture> ERROR_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, ErrorCapture>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, ErrorCapture error) {
            event.setError(error);
        }
    };
    private static final EventTranslator<ReportingEvent> SHUTDOWN_EVENT_TRANSLATOR = new EventTranslator<ReportingEvent>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence) {
            event.shutdownEvent();
        }
    };
    private final Disruptor<ReportingEvent> disruptor;
    private final AtomicLong dropped = new AtomicLong();
    private final boolean dropTransactionIfQueueFull;
    private final ReportingEventHandler reportingEventHandler;
    private final boolean syncReport;
    @Nullable
    private ScheduledThreadPoolExecutor metricsReportingScheduler;

    public ApmServerReporter(boolean dropTransactionIfQueueFull, ReporterConfiguration reporterConfiguration, ReportingEventHandler reportingEventHandler) {
        this.dropTransactionIfQueueFull = dropTransactionIfQueueFull;
        this.syncReport = reporterConfiguration.isReportSynchronously();
        this.disruptor = new Disruptor<ReportingEvent>(new TransactionEventFactory(), MathUtils.getNextPowerOf2(reporterConfiguration.getMaxQueueSize()), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName(ThreadUtils.addElasticApmThreadPrefix("server-reporter"));
                return thread;
            }
        }, ProducerType.MULTI, (WaitStrategy)new ExponentionallyIncreasingSleepingWaitStrategy(100000, 10000000));
        this.reportingEventHandler = reportingEventHandler;
        this.disruptor.setDefaultExceptionHandler(new IgnoreExceptionHandler());
        this.disruptor.handleEventsWith(this.reportingEventHandler);
        this.disruptor.start();
        reportingEventHandler.init(this);
    }

    @Override
    public void report(Transaction transaction) {
        if (!this.tryAddEventToRingBuffer(transaction, TRANSACTION_EVENT_TRANSLATOR)) {
            transaction.decrementReferences();
        }
        if (this.syncReport) {
            this.waitForFlush();
        }
    }

    @Override
    public void report(Span span) {
        if (!this.tryAddEventToRingBuffer(span, SPAN_EVENT_TRANSLATOR)) {
            span.decrementReferences();
        }
        if (this.syncReport) {
            this.waitForFlush();
        }
    }

    private void waitForFlush() {
        try {
            this.flush().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getDropped() {
        return this.dropped.get() + this.reportingEventHandler.getDropped();
    }

    @Override
    public long getReported() {
        return this.reportingEventHandler.getReported();
    }

    @Override
    public Future<Void> flush() {
        boolean success = this.disruptor.getRingBuffer().tryPublishEvent(FLUSH_EVENT_TRANSLATOR);
        if (!success) {
            throw new IllegalStateException("Ring buffer has no available slots");
        }
        final long cursor = this.disruptor.getCursor();
        return new Future<Void>(){
            private volatile boolean cancelled = false;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isDone()) {
                    return false;
                }
                ((ReportingEvent)ApmServerReporter.this.disruptor.get(cursor)).resetState();
                this.cancelled = true;
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return ApmServerReporter.this.isEventProcessed(cursor);
            }

            @Override
            public Void get() throws InterruptedException {
                while (!this.isDone()) {
                    Thread.sleep(1L);
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                while (timeout > 0L && !this.isDone()) {
                    Thread.sleep(1L);
                    --timeout;
                }
                if (!this.isDone()) {
                    throw new TimeoutException();
                }
                return null;
            }
        };
    }

    private boolean isEventProcessed(long sequence) {
        return this.disruptor.getSequenceValueFor(this.reportingEventHandler) >= sequence;
    }

    @Override
    public void close() {
        logger.info("dropped events because of full queue: {}", (Object)this.dropped.get());
        this.disruptor.getRingBuffer().tryPublishEvent(SHUTDOWN_EVENT_TRANSLATOR);
        try {
            this.disruptor.shutdown(5L, TimeUnit.SECONDS);
        }
        catch (co.elastic.apm.agent.shaded.lmax.disruptor.TimeoutException e) {
            logger.warn("Timeout while shutting down disruptor");
        }
        this.reportingEventHandler.close();
        if (this.metricsReportingScheduler != null) {
            this.metricsReportingScheduler.shutdown();
        }
    }

    @Override
    public void report(ErrorCapture error) {
        if (!this.tryAddEventToRingBuffer(error, ERROR_EVENT_TRANSLATOR)) {
            error.recycle();
        }
        if (this.syncReport) {
            this.waitForFlush();
        }
    }

    @Override
    public void scheduleMetricReporting(final MetricRegistry metricRegistry, long intervalMs, final ElasticApmTracer tracer) {
        if (intervalMs > 0L && this.metricsReportingScheduler == null) {
            this.metricsReportingScheduler = ExecutorUtils.createSingleThreadSchedulingDeamonPool("metrics-reporter");
            this.metricsReportingScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!tracer.isRunning()) {
                        return;
                    }
                    ApmServerReporter.this.disruptor.getRingBuffer().tryPublishEvent(new EventTranslatorOneArg<ReportingEvent, MetricRegistry>(){

                        @Override
                        public void translateTo(ReportingEvent event, long sequence, MetricRegistry metricRegistry) {
                            event.reportMetrics(metricRegistry);
                        }
                    }, metricRegistry);
                }
            }, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
        }
    }

    private <E> boolean tryAddEventToRingBuffer(E event, EventTranslatorOneArg<ReportingEvent, E> eventTranslator) {
        if (this.dropTransactionIfQueueFull) {
            boolean queueFull;
            boolean bl = queueFull = !this.disruptor.getRingBuffer().tryPublishEvent(eventTranslator, event);
            if (queueFull) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not add {} {} to ring buffer as no slots are available", (Object)event.getClass().getSimpleName(), (Object)event);
                }
                this.dropped.incrementAndGet();
                return false;
            }
        } else {
            this.disruptor.getRingBuffer().publishEvent(eventTranslator, event);
        }
        return true;
    }

    static class TransactionEventFactory
    implements EventFactory<ReportingEvent> {
        TransactionEventFactory() {
        }

        @Override
        public ReportingEvent newInstance() {
            return new ReportingEvent();
        }
    }
}

