/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.lmax.disruptor;

import co.elastic.apm.agent.logging.JulBridgeLogger;
import co.elastic.apm.agent.shaded.lmax.disruptor.ExceptionHandler;
import java.util.logging.Level;

public final class FatalExceptionHandler
implements ExceptionHandler<Object> {
    private static final JulBridgeLogger LOGGER = JulBridgeLogger.getLogger(FatalExceptionHandler.class.getName());
    private final JulBridgeLogger logger;

    public FatalExceptionHandler() {
        this.logger = LOGGER;
    }

    public FatalExceptionHandler(JulBridgeLogger logger) {
        this.logger = logger;
    }

    @Override
    public void handleEventException(Throwable ex, long sequence, Object event) {
        this.logger.log(Level.SEVERE, "Exception processing: " + sequence + " " + event, ex);
        throw new RuntimeException(ex);
    }

    @Override
    public void handleOnStartException(Throwable ex) {
        this.logger.log(Level.SEVERE, "Exception during onStart()", ex);
    }

    @Override
    public void handleOnShutdownException(Throwable ex) {
        this.logger.log(Level.SEVERE, "Exception during onShutdown()", ex);
    }
}

