/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.webmvc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.springframework.web.method.HandlerMethod;

public class SpringTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(SpringTransactionNameInstrumentation.class);

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("org.springframework.web.servlet").and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.HandlerAdapter"))).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, Object.class));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("org.springframework.web.method.HandlerMethod");
    }

    @Override
    public Class<?> getAdviceClass() {
        return HandlerAdapterAdvice.class;
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("spring-mvc");
    }

    public static class HandlerAdapterAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        static void setTransactionName(@Advice.Argument(value=2) Object handler) {
            if (ElasticApmInstrumentation.tracer != null) {
                Transaction transaction = ElasticApmInstrumentation.tracer.currentTransaction();
                if (transaction != null) {
                    String methodName;
                    String className;
                    if (handler instanceof HandlerMethod) {
                        HandlerMethod handlerMethod = (HandlerMethod)handler;
                        className = handlerMethod.getBeanType().getSimpleName();
                        methodName = handlerMethod.getMethod().getName();
                    } else {
                        className = handler.getClass().getSimpleName();
                        methodName = null;
                    }
                    HandlerAdapterAdvice.setName(transaction, className, methodName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Set name {} to transaction {}", (Object)transaction.getNameAsString(), (Object)transaction.getTraceContext().getId());
                    }
                } else {
                    logger.debug("Transaction is null");
                }
            } else {
                logger.debug("Tracer is null");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Stack trace: ", new RuntimeException());
            }
        }

        public static void setName(Transaction transaction, String className, @Nullable String methodName) {
            StringBuilder name = transaction.getAndOverrideName(100);
            if (name != null) {
                name.append(className);
                if (methodName != null) {
                    name.append('#').append(methodName);
                }
            }
        }
    }
}

