/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.webmvc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.web.servlet.view.AbstractView;

public class ViewRenderInstrumentation
extends ElasticApmInstrumentation {
    private static final String SPAN_TYPE = "template";
    private static final String SPAN_ACTION = "render";
    private static final String DISPATCHER_SERVLET_RENDER_METHOD = "View#render";
    private static Map<String, String> subTypeCache = new ConcurrentHashMap<String, String>();

    @Override
    public Class<?> getAdviceClass() {
        return ViewRenderAdviceService.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("View");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.View"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named(SPAN_ACTION).and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.Map"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("javax.servlet.http.HttpServletResponse")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("spring-view-render");
    }

    public static class ViewRenderAdviceService {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void beforeExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.This @Nullable Object thiz) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
            String className = thiz.getClass().getName();
            span = (Span)parent.createSpan().withType(ViewRenderInstrumentation.SPAN_TYPE).withSubtype(ViewRenderAdviceService.getSubtype(className)).withAction(ViewRenderInstrumentation.SPAN_ACTION).withName(ViewRenderInstrumentation.DISPATCHER_SERVLET_RENDER_METHOD);
            if (thiz instanceof AbstractView) {
                AbstractView view = (AbstractView)thiz;
                ((Span)span.appendToName(" ")).appendToName(view.getBeanName());
            }
            span.activate();
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void afterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }

        public static String getSubtype(String className) {
            switch (className) {
                case "org.springframework.web.servlet.view.groovy.GroovyMarkupView": {
                    return "GroovyMarkup";
                }
                case "org.springframework.web.servlet.view.freemarker.FreeMarkerView": {
                    return "FreeMarker";
                }
                case "org.springframework.web.servlet.view.json.MappingJackson2JsonView": {
                    return "MappingJackson2Json";
                }
                case "de.neuland.jade4j.spring.view.JadeView": {
                    return "Jade";
                }
                case "org.springframework.web.servlet.view.InternalResourceView": {
                    return "InternalResource";
                }
                case "org.thymeleaf.spring4.view.ThymeleafView": {
                    return "Thymeleaf";
                }
            }
            String subType = (String)subTypeCache.get(className);
            if (subType != null) {
                return subType;
            }
            int indexOfLastDot = className.lastIndexOf(46);
            int indexOfView = className.lastIndexOf("View");
            subType = className.substring(indexOfLastDot + 1, indexOfView > indexOfLastDot ? indexOfView : className.length());
            if (subTypeCache.size() < 1000) {
                subTypeCache.put(className, subType);
            }
            return subType;
        }
    }
}

