/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.shaded.dslplatform.json.DslJson;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.agent.shaded.dslplatform.json.MapConverter;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ApmServerConfigurationSource
extends AbstractConfigurationSource
implements LifecycleListener {
    private static final int SC_OK = 200;
    private static final int SC_NOT_MODIFIED = 304;
    private static final int SC_FORBIDDEN = 403;
    private static final int SC_NOT_FOUND = 404;
    private static final int SC_SERVICE_UNAVAILABLE = 503;
    private static final int DEFAULT_POLL_DELAY_SEC = (int)TimeUnit.MINUTES.toSeconds(5L);
    private static final Pattern MAX_AGE = Pattern.compile("max-age\\s*=\\s*(\\d+)");
    private final Logger logger;
    private final DslJson<Object> dslJson = new DslJson(new DslJson.Settings());
    private final byte[] buffer = new byte[4096];
    private final PayloadSerializer payloadSerializer;
    private final MetaData metaData;
    private final ApmServerClient apmServerClient;
    @Nullable
    private String etag;
    private volatile Map<String, String> config = Collections.emptyMap();
    @Nullable
    private volatile ThreadPoolExecutor threadPool;

    public ApmServerConfigurationSource(PayloadSerializer payloadSerializer, MetaData metaData, ApmServerClient apmServerClient) {
        this(payloadSerializer, metaData, apmServerClient, LoggerFactory.getLogger(ApmServerConfigurationSource.class));
    }

    ApmServerConfigurationSource(PayloadSerializer payloadSerializer, MetaData metaData, ApmServerClient apmServerClient, Logger logger) {
        this.payloadSerializer = payloadSerializer;
        this.metaData = metaData;
        this.apmServerClient = apmServerClient;
        this.logger = logger;
    }

    @Nullable
    static Integer parseMaxAge(@Nullable String cacheControlHeader) {
        if (cacheControlHeader == null) {
            return null;
        }
        Matcher matcher = MAX_AGE.matcher(cacheControlHeader);
        if (!matcher.find()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }

    @Override
    public void reload() {
    }

    @Override
    public void init(ElasticApmTracer tracer) throws Exception {
    }

    @Override
    public void start(final ElasticApmTracer tracer) {
        this.threadPool = ExecutorUtils.createSingleThreadDeamonPool("remote-config-poller", 1);
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                ApmServerConfigurationSource.this.pollConfig(tracer.getConfigurationRegistry());
            }
        });
    }

    private void pollConfig(ConfigurationRegistry configurationRegistry) {
        while (!Thread.currentThread().isInterrupted()) {
            String cacheControlHeader = this.fetchConfig(configurationRegistry);
            Integer pollDelaySec = ApmServerConfigurationSource.parseMaxAge(cacheControlHeader);
            if (pollDelaySec == null) {
                pollDelaySec = DEFAULT_POLL_DELAY_SEC;
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Scheduling next remote configuration reload in {}s", (Object)pollDelaySec);
                }
                TimeUnit.SECONDS.sleep(pollDelaySec.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nullable
    String fetchConfig(final ConfigurationRegistry configurationRegistry) {
        if (!configurationRegistry.getConfig(CoreConfiguration.class).isCentralConfigEnabled()) {
            this.logger.debug("Remote configuration is disabled");
            return null;
        }
        try {
            return this.apmServerClient.execute("/config/v1/agents", new ApmServerClient.ConnectionHandler<String>(){

                @Override
                public String withConnection(HttpURLConnection connection) throws IOException {
                    return ApmServerConfigurationSource.this.tryFetchConfig(configurationRegistry, connection);
                }
            });
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    private String tryFetchConfig(ConfigurationRegistry configurationRegistry, HttpURLConnection connection) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reloading configuration from APM Server {}", (Object)connection.getURL());
        }
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        if (this.etag != null) {
            connection.setRequestProperty("If-None-Match", this.etag);
        }
        this.payloadSerializer.setOutputStream(connection.getOutputStream());
        this.payloadSerializer.serializeMetadata(this.metaData);
        this.payloadSerializer.flush();
        this.etag = connection.getHeaderField("ETag");
        int status = connection.getResponseCode();
        switch (status) {
            case 200: {
                InputStream is = connection.getInputStream();
                JsonReader<Object> reader = this.dslJson.newReader(is, this.buffer);
                reader.startObject();
                this.config = MapConverter.deserialize(reader);
                configurationRegistry.reloadDynamicConfigurationOptions();
                this.logger.info("Received new configuration from APM Server: {}", (Object)this.config);
                for (Map.Entry<String, String> entry : this.config.entrySet()) {
                    ConfigurationOption<?> conf = configurationRegistry.getConfigurationOptionByKey(entry.getKey());
                    if (conf == null) {
                        this.logger.warn("Received unknown remote configuration key {}", (Object)entry.getKey());
                        continue;
                    }
                    if (conf.isDynamic()) continue;
                    this.logger.warn("Can't apply remote configuration {} as this option is not dynamic (aka. reloadable)", (Object)entry.getKey());
                }
                break;
            }
            case 304: {
                this.logger.debug("Configuration did not change");
                break;
            }
            case 404: {
                this.logger.debug("This APM Server does not support central configuration. Update to APM Server 7.3+");
                break;
            }
            case 403: {
                this.logger.debug("Central configuration is disabled. Set kibana.enabled: true in your APM Server configuration.");
                break;
            }
            case 503: {
                throw new IllegalStateException("Remote configuration is not available. Check the connection between APM Server and Kibana.");
            }
            default: {
                throw new IllegalStateException("Unexpected status " + status + " while fetching configuration");
            }
        }
        return connection.getHeaderField("Cache-Control");
    }

    @Override
    public String getValue(String key) {
        return this.config.get(key);
    }

    @Override
    public String getName() {
        return "APM Server";
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void stop() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }
}

