/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceNameUtil {
    private static final String JAR_VERSION_SUFFIX = "-(\\d+\\.)+(\\d+)(.*)?$";

    public static String getDefaultServiceName() {
        return ServiceNameUtil.getDefaultServiceName(System.getProperty("sun.java.command"));
    }

    static String getDefaultServiceName(@Nullable String sunJavaCommand) {
        String serviceName = ServiceNameUtil.parseSunJavaCommand(sunJavaCommand);
        if (serviceName != null) {
            serviceName = ServiceNameUtil.replaceDisallowedChars(serviceName);
            serviceName = serviceName.trim();
        }
        if (serviceName == null || serviceName.isEmpty()) {
            serviceName = "my-service";
        }
        return serviceName;
    }

    @Nullable
    private static String parseSunJavaCommand(@Nullable String command) {
        if (command == null) {
            return null;
        }
        String serviceName = ServiceNameUtil.getContainerServiceName(command = command.trim());
        if (serviceName != null) {
            return serviceName;
        }
        serviceName = command.contains(".jar") ? ServiceNameUtil.parseJarCommand(command) : ServiceNameUtil.parseMainClass(command);
        return serviceName;
    }

    @Nullable
    private static String getContainerServiceName(String command) {
        if (command.startsWith("org.apache.catalina.startup.Bootstrap")) {
            return "tomcat-application";
        }
        if (command.startsWith("org.eclipse.jetty")) {
            return "jetty-application";
        }
        if (command.startsWith("com.sun.enterprise.glassfish")) {
            return "glassfish-application";
        }
        if (command.contains("ws-server.jar")) {
            return "websphere-application";
        }
        if (command.contains("jboss-modules.jar")) {
            return "jboss-application";
        }
        if (command.contains("weblogic")) {
            return "weblogic-application";
        }
        return null;
    }

    public static String replaceDisallowedChars(String serviceName) {
        return serviceName.replaceAll("[^a-zA-Z0-9 _-]", "-");
    }

    @Nullable
    private static String parseJarCommand(String command) {
        String[] commandParts = command.split(" ");
        String result = null;
        for (String commandPart : commandParts) {
            if (!commandPart.endsWith(".jar")) continue;
            result = ServiceNameUtil.removeVersionFromJar(ServiceNameUtil.removePath(ServiceNameUtil.removeJarExtension(commandPart)));
            break;
        }
        return result;
    }

    @Nonnull
    private static String removeJarExtension(String commandPart) {
        return commandPart.substring(0, commandPart.indexOf(".jar"));
    }

    private static String removePath(String path) {
        return path.substring(path.lastIndexOf("/") + 1).substring(path.lastIndexOf("\\") + 1);
    }

    private static String removeVersionFromJar(String jarFileName) {
        return jarFileName.replaceFirst(JAR_VERSION_SUFFIX, "");
    }

    private static String parseMainClass(String command) {
        int indexOfSpace = command.indexOf(32);
        String mainClassName = indexOfSpace != -1 ? command.substring(0, indexOfSpace) : command;
        return mainClassName.substring(mainClassName.lastIndexOf(46) + 1);
    }
}

