/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.source;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertyFileConfigurationSource
extends AbstractConfigurationSource {
    private final String location;
    private Properties properties;

    public PropertyFileConfigurationSource(String location) {
        this.location = location;
        this.reload();
    }

    public static boolean isPresent(String location) {
        return PropertyFileConfigurationSource.getProperties(location) != null;
    }

    private static Properties getProperties(String location) {
        if (location == null) {
            return null;
        }
        Properties props = PropertyFileConfigurationSource.getFromClasspath(location, ClassLoader.getSystemClassLoader());
        if (props == null) {
            props = PropertyFileConfigurationSource.getFromFileSystem(location);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getFromClasspath(String classpathLocation, ClassLoader classLoader) {
        Properties props = new Properties();
        try (InputStream resourceStream = classLoader.getResourceAsStream(classpathLocation);){
            if (resourceStream == null) return null;
            props.load(resourceStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Properties getFromFileSystem(String location) {
        Properties properties;
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(location);
        Throwable throwable = null;
        try {
            props.load(input);
            properties = props;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    PropertyFileConfigurationSource.$closeResource(throwable, input);
                    throw throwable3;
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        PropertyFileConfigurationSource.$closeResource(throwable, input);
        return properties;
    }

    @Override
    public void reload() {
        this.properties = PropertyFileConfigurationSource.getProperties(this.location);
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    @Override
    public String getName() {
        return this.location;
    }

    @Override
    public String getValue(String key) {
        return this.properties.getProperty(key);
    }
}

