/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaResponseFutureInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class AlibabaRpcContextInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    public static final List<Class<? extends ElasticApmInstrumentation>> RESPONSE_FUTURE_INSTRUMENTATION = Collections.singletonList(AlibabaResponseFutureInstrumentation.class);

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.alibaba.dubbo.rpc.RpcContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setFuture").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.concurrent.Future")));
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void onEnter(@Advice.Argument(value=0) Future<?> future) {
        if (future instanceof FutureAdapter) {
            ElasticApmAgent.ensureInstrumented(((FutureAdapter)future).getFuture().getClass(), RESPONSE_FUTURE_INSTRUMENTATION);
        }
    }
}

