/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.advice;

import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.dubbo.helper.ApacheDubboAttachmentHelper;
import co.elastic.apm.agent.dubbo.helper.AsyncCallbackCreator;
import co.elastic.apm.agent.dubbo.helper.DubboTraceHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import javax.annotation.Nullable;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;

public class ApacheMonitorFilterAdvice {
    @Nullable
    public static ElasticApmTracer tracer;
    public static HelperClassManager<ApacheDubboAttachmentHelper> attachmentHelperClassManager;
    public static HelperClassManager<AsyncCallbackCreator> asyncCallbackCreatorClassManager;

    public static void init(ElasticApmTracer tracer) {
        ApacheMonitorFilterAdvice.tracer = tracer;
        attachmentHelperClassManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.dubbo.helper.ApacheDubboAttachmentHelperImpl", new String[0]);
        asyncCallbackCreatorClassManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.dubbo.helper.AsyncCallbackCreatorImpl", "co.elastic.apm.agent.dubbo.helper.AsyncCallbackCreatorImpl$AsyncCallback");
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnterFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Local(value="span") Span span, @Advice.Local(value="transaction") Transaction transaction) {
        RpcContext context = RpcContext.getContext();
        ApacheDubboAttachmentHelper helper = attachmentHelperClassManager.getForClassLoaderOfClass(Invocation.class);
        if (helper == null || tracer == null) {
            return;
        }
        AbstractSpan<?> active = tracer.getActive();
        if (context.isConsumerSide() && active != null) {
            span = DubboTraceHelper.createConsumerSpan(tracer, invocation.getInvoker().getInterface(), invocation.getMethodName(), context.getRemoteAddress());
            if (span != null) {
                span.propagateTraceContext(invocation, helper);
            }
        } else if (active == null && (transaction = tracer.startChildTransaction(invocation, helper, Invocation.class.getClassLoader())) != null) {
            transaction.activate();
            DubboTraceHelper.fillTransaction(transaction, invocation.getInvoker().getInterface(), invocation.getMethodName());
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onExitFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Return Result result, @Nullable @Advice.Local(value="span") Span span, @Advice.Thrown Throwable t, @Nullable @Advice.Local(value="transaction") Transaction transaction) {
        AbstractSpan actualSpan;
        RpcContext context = RpcContext.getContext();
        AbstractSpan abstractSpan = actualSpan = context.isConsumerSide() ? span : transaction;
        if (actualSpan == null) {
            return;
        }
        actualSpan.deactivate();
        if (result instanceof AsyncRpcResult) {
            AsyncCallbackCreator callbackCreator = asyncCallbackCreatorClassManager.getForClassLoaderOfClass(Result.class);
            if (callbackCreator == null) {
                actualSpan.end();
                return;
            }
            context.set("_elastic_apm_span", (Object)actualSpan);
            result.whenCompleteWithContext(callbackCreator.create(actualSpan));
        } else {
            actualSpan.end();
        }
    }
}

