/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.grpc.ServerCall;
import io.grpc.Status;
import javax.annotation.Nullable;

public class ServerCallInstrumentation
extends BaseInstrumentation {
    public ServerCallInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc").and(ElementMatchers.nameContains("ServerCall"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.ServerCall"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("close");
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    private static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall<?, ?> serverCall, @Advice.Argument(value=0) Status status) {
        if (tracer == null || grpcHelperManager == null) {
            return;
        }
        GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.class);
        if (helper != null) {
            helper.setTransactionStatus(status, thrown, serverCall);
        }
    }
}

