/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.grpc.ServerCall;
import javax.annotation.Nullable;

public abstract class ServerCallListenerInstrumentation
extends BaseInstrumentation {
    public ServerCallListenerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.ServerCall$Listener"));
    }

    public static class FinalMethodCall
    extends ServerCallListenerInstrumentation {
        public FinalMethodCall(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onCancel").or(ElementMatchers.named("onComplete"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This ServerCall.Listener<?> listener, @Advice.Local(value="transaction") Transaction transaction) {
            if (null == tracer || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.Listener.class);
            if (helper == null) {
                return;
            }
            transaction = helper.enterServerListenerMethod(listener);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall.Listener<?> listener, @Advice.Local(value="transaction") @Nullable Transaction transaction) {
            if (null == tracer || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.Listener.class);
            if (helper == null) {
                return;
            }
            helper.exitServerListenerMethod(thrown, listener, transaction, true);
        }
    }

    public static class NonFinalMethodCall
    extends ServerCallListenerInstrumentation {
        public NonFinalMethodCall(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onReady").or(ElementMatchers.named("onMessage")).or(ElementMatchers.named("onHalfClose"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This ServerCall.Listener<?> listener, @Advice.Local(value="transaction") Transaction transaction) {
            if (null == tracer || grpcHelperManager == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.Listener.class);
            if (helper == null) {
                return;
            }
            transaction = helper.enterServerListenerMethod(listener);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall.Listener<?> listener, @Advice.Local(value="transaction") @Nullable Transaction transaction) {
            if (null == tracer || grpcHelperManager == null || transaction == null) {
                return;
            }
            GrpcHelper helper = (GrpcHelper)grpcHelperManager.getForClassLoaderOfClass(ServerCall.Listener.class);
            if (helper == null) {
                return;
            }
            helper.exitServerListenerMethod(thrown, listener, transaction, false);
        }
    }
}

