/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc.helper;

import co.elastic.apm.agent.grpc.helper.GrpcHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import javax.annotation.Nullable;

public class GrpcHelperImpl
implements GrpcHelper {
    private static final String FRAMEWORK_NAME = "gRPC";
    private static final WeakConcurrentMap<ClientCall<?, ?>, Span> clientCallSpans = new WeakConcurrentMap.WithInlinedExpunction();
    private static final WeakConcurrentMap<ClientCall.Listener<?>, Span> clientCallListenerSpans = new WeakConcurrentMap.WithInlinedExpunction();
    private static final WeakConcurrentMap<ServerCall.Listener<?>, Transaction> serverListenerTransactions = new WeakConcurrentMap.WithInlinedExpunction();
    private static final WeakConcurrentMap<ServerCall<?, ?>, Transaction> serverCallTransactions = new WeakConcurrentMap.WithInlinedExpunction();
    private static final WeakConcurrentMap.WithInlinedExpunction<String, Metadata.Key<String>> headerCache = new WeakConcurrentMap.WithInlinedExpunction();
    private static final TextHeaderSetter<Metadata> headerSetter = new GrpcHeaderSetter();
    private static final TextHeaderGetter<Metadata> headerGetter = new GrpcHeaderGetter();

    @Override
    @Nullable
    public Transaction startTransaction(ElasticApmTracer tracer, ClassLoader cl, ServerCall<?, ?> serverCall, Metadata headers) {
        MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
        if (methodDescriptor.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        if (tracer.getActive() != null) {
            return null;
        }
        Transaction transaction = tracer.startChildTransaction(headers, headerGetter, cl);
        if (transaction == null) {
            return null;
        }
        ((Transaction)transaction.withName(methodDescriptor.getFullMethodName())).withType("request").setFrameworkName(FRAMEWORK_NAME);
        return (Transaction)transaction.activate();
    }

    @Override
    public void registerTransaction(ServerCall<?, ?> serverCall, ServerCall.Listener<?> listener, Transaction transaction) {
        serverCallTransactions.put(serverCall, transaction);
        serverListenerTransactions.put(listener, transaction);
        transaction.deactivate();
    }

    @Override
    public void setTransactionStatus(Status status, @Nullable Throwable thrown, ServerCall<?, ?> serverCall) {
        Transaction transaction = serverCallTransactions.remove(serverCall);
        if (transaction != null) {
            this.setTransactionStatus(status, thrown, transaction);
            if (thrown != null) {
                transaction.end();
            }
        }
    }

    private void setTransactionStatus(Status status, @Nullable Throwable thrown, Transaction transaction) {
        transaction.withResultIfUnset(status.getCode().name()).captureException(thrown);
    }

    @Override
    @Nullable
    public Transaction enterServerListenerMethod(ServerCall.Listener<?> listener) {
        Transaction transaction = serverListenerTransactions.get(listener);
        if (transaction != null) {
            transaction.activate();
        }
        return transaction;
    }

    @Override
    public void exitServerListenerMethod(@Nullable Throwable thrown, ServerCall.Listener<?> listener, @Nullable Transaction transaction, boolean isLastMethod) {
        if (transaction == null) {
            return;
        }
        transaction.deactivate();
        if (isLastMethod || null != thrown) {
            if (thrown != null) {
                this.setTransactionStatus(Status.UNKNOWN, thrown, transaction);
            }
            transaction.end();
            serverListenerTransactions.remove(listener);
        }
    }

    @Override
    @Nullable
    public Span startSpan(@Nullable AbstractSpan<?> parent, @Nullable MethodDescriptor<?, ?> method, @Nullable String authority) {
        if (null == parent) {
            return null;
        }
        if (method != null && method.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        Span span = parent.createExitSpan();
        if (span == null) {
            return null;
        }
        ((Span)span.withName(method == null ? null : method.getFullMethodName())).withType("external").withSubtype("grpc");
        if (authority != null) {
            Destination destination = span.getContext().getDestination().withAddressPort(authority);
            destination.getService().withName("grpc").withResource(authority).withType("grpc");
        }
        return (Span)span.activate();
    }

    @Override
    public void registerSpan(@Nullable ClientCall<?, ?> clientCall, Span span) {
        if (clientCall != null) {
            clientCallSpans.put(clientCall, span);
        }
        span.deactivate();
    }

    @Override
    public Span clientCallStartEnter(ClientCall<?, ?> clientCall, ClientCall.Listener<?> listener, Metadata headers) {
        Span span = clientCallSpans.remove(clientCall);
        if (span == null) {
            return null;
        }
        clientCallListenerSpans.put(listener, span);
        span.propagateTraceContext(headers, headerSetter);
        return span;
    }

    @Override
    public void clientCallStartExit(ClientCall.Listener<?> listener, @Nullable Throwable thrown) {
        if (thrown == null) {
            return;
        }
        Span span = clientCallListenerSpans.remove(listener);
        if (span != null) {
            span.end();
        }
    }

    @Override
    @Nullable
    public Span enterClientListenerMethod(ClientCall.Listener<?> listener) {
        Span span = clientCallListenerSpans.get(listener);
        if (span != null) {
            span.activate();
        }
        return span;
    }

    @Override
    public void exitClientListenerMethod(@Nullable Throwable thrown, ClientCall.Listener<?> listener, @Nullable Span span, boolean isLastMethod) {
        if (span != null) {
            ((Span)span.captureException(thrown)).deactivate();
        }
        if (span != null && (isLastMethod || thrown != null)) {
            span.end();
        }
        if (isLastMethod) {
            clientCallListenerSpans.remove(listener);
        }
    }

    private static Metadata.Key<String> getHeader(String headerName) {
        Metadata.Key key = headerCache.get(headerName);
        if (key == null) {
            key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headerCache.put(headerName, (Metadata.Key<String>)key);
        }
        return key;
    }

    public static class GrpcHeaderGetter
    extends AbstractHeaderGetter<String, Metadata>
    implements TextHeaderGetter<Metadata> {
        @Override
        @Nullable
        public String getFirstHeader(String headerName, Metadata carrier) {
            return (String)carrier.get(GrpcHelperImpl.getHeader(headerName));
        }
    }

    public static class GrpcHeaderSetter
    implements TextHeaderSetter<Metadata> {
        @Override
        public void setHeader(String headerName, String headerValue, Metadata carrier) {
            carrier.put(GrpcHelperImpl.getHeader(headerName), (Object)headerValue);
        }
    }
}

