/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.helper;

import co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelper;
import co.elastic.apm.agent.httpclient.helper.FutureCallbackWrapper;
import co.elastic.apm.agent.httpclient.helper.HttpAsyncRequestProducerWrapper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpAsyncClientHelperImpl
implements ApacheHttpAsyncClientHelper<HttpAsyncRequestProducer, FutureCallback<?>, HttpContext, HttpRequest> {
    private static final int MAX_POOLED_ELEMENTS = 256;
    private final ObjectPool<HttpAsyncRequestProducerWrapper> requestProducerWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new RequestProducerWrapperAllocator());
    private final ObjectPool<FutureCallbackWrapper<?>> futureCallbackWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new FutureCallbackWrapperAllocator());

    @Override
    public HttpAsyncRequestProducer wrapRequestProducer(HttpAsyncRequestProducer requestProducer, Span span, TextHeaderSetter<HttpRequest> headerSetter) {
        return this.requestProducerWrapperObjectPool.createInstance().with(requestProducer, span, headerSetter);
    }

    @Override
    public FutureCallback wrapFutureCallback(FutureCallback futureCallback, HttpContext context, Span span) {
        return this.futureCallbackWrapperObjectPool.createInstance().with(futureCallback, context, span);
    }

    void recycle(HttpAsyncRequestProducerWrapper requestProducerWrapper) {
        this.requestProducerWrapperObjectPool.recycle(requestProducerWrapper);
    }

    void recycle(FutureCallbackWrapper futureCallbackWrapper) {
        this.futureCallbackWrapperObjectPool.recycle(futureCallbackWrapper);
    }

    private class FutureCallbackWrapperAllocator
    implements Allocator<FutureCallbackWrapper<?>> {
        private FutureCallbackWrapperAllocator() {
        }

        @Override
        public FutureCallbackWrapper<?> createInstance() {
            return new FutureCallbackWrapper(ApacheHttpAsyncClientHelperImpl.this);
        }
    }

    private class RequestProducerWrapperAllocator
    implements Allocator<HttpAsyncRequestProducerWrapper> {
        private RequestProducerWrapperAllocator() {
        }

        @Override
        public HttpAsyncRequestProducerWrapper createInstance() {
            return new HttpAsyncRequestProducerWrapper(ApacheHttpAsyncClientHelperImpl.this);
        }
    }
}

