/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.helper;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class RequestHeaderAccessor
implements TextHeaderGetter<HttpRequest>,
TextHeaderSetter<HttpRequest> {
    @Override
    public void setHeader(String headerName, String headerValue, HttpRequest request) {
        request.setHeader(headerName, headerValue);
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, HttpRequest request) {
        Header header = request.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, HttpRequest carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        Header[] headers = carrier.getHeaders(headerName);
        if (headers != null) {
            for (Header header : headers) {
                consumer.accept(header.getValue(), state);
            }
        }
    }
}

