/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.payload.ProcessFactory;
import co.elastic.apm.agent.impl.payload.ProcessInfo;
import co.elastic.apm.agent.impl.payload.Service;
import co.elastic.apm.agent.impl.payload.ServiceFactory;
import co.elastic.apm.agent.impl.payload.SystemInfo;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class MetaData {
    private final Service service;
    private final ProcessInfo process;
    private final SystemInfo system;
    private final ArrayList<String> globalLabelKeys;
    private final ArrayList<String> globalLabelValues;

    public MetaData(ProcessInfo process, Service service, SystemInfo system, Map<String, String> globalLabels) {
        this.process = process;
        this.service = service;
        this.system = system;
        this.globalLabelKeys = new ArrayList<String>(globalLabels.keySet());
        this.globalLabelValues = new ArrayList<String>(globalLabels.values());
    }

    public static MetaData create(ConfigurationRegistry configurationRegistry, @Nullable String ephemeralId) {
        if (ephemeralId == null) {
            ephemeralId = UUID.randomUUID().toString();
        }
        CoreConfiguration coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        Service service = new ServiceFactory().createService(coreConfiguration, ephemeralId);
        ProcessInfo processInformation = ProcessFactory.ForCurrentVM.INSTANCE.getProcessInformation();
        if (!configurationRegistry.getConfig(ReporterConfiguration.class).isIncludeProcessArguments()) {
            processInformation.getArgv().clear();
        }
        return new MetaData(processInformation, service, SystemInfo.create(coreConfiguration.getHostname()), coreConfiguration.getGlobalLabels());
    }

    public Service getService() {
        return this.service;
    }

    public ProcessInfo getProcess() {
        return this.process;
    }

    public SystemInfo getSystem() {
        return this.system;
    }

    public ArrayList<String> getGlobalLabelKeys() {
        return this.globalLabelKeys;
    }

    public ArrayList<String> getGlobalLabelValues() {
        return this.globalLabelValues;
    }
}

