/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.util.BinaryHeaderMap;
import co.elastic.apm.agent.util.NoRandomAccessMap;
import java.util.Iterator;
import javax.annotation.Nullable;

public class Headers
implements Recyclable,
Iterable<Header> {
    private final NoRandomAccessMap<String, String> textHeaders = new NoRandomAccessMap();
    private final BinaryHeaderMap binaryHeaders = new BinaryHeaderMap();
    private final NoGarbageIterator iterator = new NoGarbageIterator();

    public void add(String key, String value) {
        this.textHeaders.add(key, value);
    }

    public boolean add(String key, byte[] value) {
        return this.binaryHeaders.add(key, value);
    }

    @Override
    public void resetState() {
        this.textHeaders.resetState();
        this.binaryHeaders.resetState();
    }

    public int size() {
        return this.textHeaders.size() + this.binaryHeaders.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Header> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void copyFrom(Headers other) {
        this.textHeaders.copyFrom(other.textHeaders);
        this.binaryHeaders.copyFrom(other.binaryHeaders);
    }

    private class NoGarbageIterator
    implements Iterator<Header> {
        private Iterator<NoRandomAccessMap.Entry<String, String>> textHeadersIterator;
        private Iterator<BinaryHeaderMap.Entry> binaryHeadersIterator;
        private final HeaderImpl header = new HeaderImpl();

        private NoGarbageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.textHeadersIterator.hasNext() || this.binaryHeadersIterator.hasNext();
        }

        @Override
        public Header next() {
            if (this.textHeadersIterator.hasNext()) {
                NoRandomAccessMap.Entry<String, String> textHeader = this.textHeadersIterator.next();
                this.header.key = textHeader.getKey();
                this.header.value = textHeader.getValue();
            } else if (this.binaryHeadersIterator.hasNext()) {
                BinaryHeaderMap.Entry binaryHeader = this.binaryHeadersIterator.next();
                this.header.key = binaryHeader.getKey();
                this.header.value = binaryHeader.getValue();
            } else {
                throw new IllegalStateException("next() called on a depleted iterator");
            }
            return this.header;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void reset() {
            this.textHeadersIterator = Headers.this.textHeaders.iterator();
            this.binaryHeadersIterator = Headers.this.binaryHeaders.iterator();
            this.header.reset();
        }
    }

    private static class HeaderImpl
    implements Header {
        @Nullable
        String key;
        @Nullable
        CharSequence value;

        private HeaderImpl() {
        }

        @Override
        public String getKey() {
            if (this.key == null) {
                throw new IllegalStateException("Key shouldn't be null. Make sure you don't read and write to this map concurrently");
            }
            return this.key;
        }

        @Override
        @Nullable
        public CharSequence getValue() {
            return this.value;
        }

        void reset() {
            this.key = null;
            this.value = null;
        }
    }

    public static interface Header {
        public String getKey();

        @Nullable
        public CharSequence getValue();
    }
}

