/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jaxws;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;

public class JaxWsTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    private static final String FRAMEWORK_NAME = "JAX-WS";
    private final Collection<String> applicationPackages;

    public JaxWsTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature) {
        Transaction transaction;
        if (tracer != null && (transaction = tracer.currentTransaction()) != null) {
            transaction.withName(signature, 100);
            transaction.setFrameworkName(FRAMEWORK_NAME);
        }
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any());
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.jws.WebService")).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.jws.WebService"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.named("javax.jws.WebMethod"))).onSuperClassesThat(CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("jax-ws");
    }
}

