/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.configuration.ServiceNameUtil;
import co.elastic.apm.agent.configuration.converter.ByteValue;
import co.elastic.apm.agent.logging.LogFormat;
import co.elastic.apm.agent.shaded.apache.logging.log4j.Level;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.LoggerContext;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.appender.ConsoleAppender;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Configuration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationFactory;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationSource;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.util.PluginManager;
import co.elastic.apm.agent.shaded.logging.log4j2.EcsLayout;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.EnumValueConverter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Log4j2ConfigurationFactory
extends ConfigurationFactory {
    private final List<co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource> sources;
    private final String ephemeralId;

    public Log4j2ConfigurationFactory(List<co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource> sources, String ephemeralId) {
        this.sources = sources;
        this.ephemeralId = ephemeralId;
    }

    static String getValue(String key, List<co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource> sources, String defaultValue) {
        for (co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource source : sources) {
            String value = source.getValue(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    @Nonnull
    static String getActualLogFile(@Nullable String agentHome, String logFile) {
        File logDir;
        if (logFile.equalsIgnoreCase("System.out")) {
            return "System.out";
        }
        if (logFile.contains("_AGENT_HOME_")) {
            if (agentHome == null) {
                System.err.println("[elastic-apm-agent] WARN - Could not resolve _AGENT_HOME_. Falling back to System.out.");
                return "System.out";
            }
            logFile = logFile.replace("_AGENT_HOME_", agentHome);
        }
        if (!(logDir = new File(logFile = new File(logFile).getAbsolutePath()).getParentFile()).exists()) {
            logDir.mkdirs();
        }
        if (!logDir.canWrite()) {
            System.err.println("[elastic-apm-agent] WARN - Log file " + logFile + " is not writable. Falling back to System.out.");
            return "System.out";
        }
        return logFile;
    }

    @Override
    protected String[] getSupportedTypes() {
        return null;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return this.getConfiguration();
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration();
    }

    public Configuration getConfiguration() {
        ConfigurationBuilder<BuiltConfiguration> builder = Log4j2ConfigurationFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR).setConfigurationName("ElasticAPM");
        Level level = Level.valueOf(Log4j2ConfigurationFactory.getValue("log_level", this.sources, Log4j2ConfigurationFactory.getValue("logging.log_level", this.sources, Level.INFO.toString())));
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        List<AppenderComponentBuilder> appenders = this.createAppenders(builder);
        for (AppenderComponentBuilder appender : appenders) {
            rootLogger.add(builder.newAppenderRef(appender.getName()));
        }
        builder.add(rootLogger);
        return (Configuration)builder.build();
    }

    private List<AppenderComponentBuilder> createAppenders(ConfigurationBuilder<BuiltConfiguration> builder) {
        ArrayList<AppenderComponentBuilder> appenders = new ArrayList<AppenderComponentBuilder>();
        String logFile = Log4j2ConfigurationFactory.getActualLogFile(ElasticApmAgent.getAgentHome(), Log4j2ConfigurationFactory.getValue("log_file", this.sources, Log4j2ConfigurationFactory.getValue("logging.log_file", this.sources, "System.out")));
        if (logFile.equals("System.out")) {
            appenders.add(this.createConsoleAppender(builder));
            if (Boolean.parseBoolean(Log4j2ConfigurationFactory.getValue("ship_agent_logs", this.sources, Boolean.TRUE.toString()))) {
                File tempLog = Log4j2ConfigurationFactory.getTempLogFile(this.ephemeralId);
                tempLog.deleteOnExit();
                File rotatedTempLog = new File(tempLog + ".1");
                rotatedTempLog.deleteOnExit();
                appenders.add(this.createFileAppender(builder, tempLog.getAbsolutePath(), this.createLayout(builder, LogFormat.JSON)));
            }
        } else {
            appenders.add(this.createFileAppender(builder, logFile, this.createLayout(builder, this.getFileLogFormat())));
        }
        for (AppenderComponentBuilder appender : appenders) {
            builder.add(appender);
        }
        return appenders;
    }

    public static File getTempLogFile(String ephemeralId) {
        return new File(System.getProperty("java.io.tmpdir"), "elasticapm-java-" + ephemeralId + ".log.json");
    }

    private AppenderComponentBuilder createConsoleAppender(ConfigurationBuilder<BuiltConfiguration> builder) {
        return ((AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", ConsoleAppender.Target.SYSTEM_OUT)).add(this.createLayout(builder, this.getSoutLogFormat()));
    }

    private LayoutComponentBuilder createLayout(ConfigurationBuilder<BuiltConfiguration> builder, LogFormat logFormat) {
        if (logFormat == LogFormat.PLAIN_TEXT) {
            return (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%thread] %-5level %logger{36} - %msg%n");
        }
        String serviceName = Log4j2ConfigurationFactory.getValue("service_name", this.sources, ServiceNameUtil.getDefaultServiceName());
        return (LayoutComponentBuilder)builder.newLayout("EcsLayout").addAttribute("eventDataset", serviceName + ".apm");
    }

    private LogFormat getSoutLogFormat() {
        return (LogFormat)((Object)new EnumValueConverter<LogFormat>(LogFormat.class).convert(Log4j2ConfigurationFactory.getValue("log_format_sout", this.sources, LogFormat.PLAIN_TEXT.toString())));
    }

    private LogFormat getFileLogFormat() {
        return (LogFormat)((Object)new EnumValueConverter<LogFormat>(LogFormat.class).convert(Log4j2ConfigurationFactory.getValue("log_format_file", this.sources, LogFormat.PLAIN_TEXT.toString())));
    }

    private AppenderComponentBuilder createFileAppender(ConfigurationBuilder<BuiltConfiguration> builder, String logFile, LayoutComponentBuilder layout) {
        ByteValue size = ByteValue.of(Log4j2ConfigurationFactory.getValue("log_file_size", this.sources, "50mb"));
        return (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", logFile)).addAttribute("filePattern", logFile + ".%i")).add(layout).addComponent((ComponentBuilder<?>)builder.newComponent("Policies").addComponent((ComponentBuilder<?>)builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", size.getBytes() + "B")))).addComponent((ComponentBuilder<?>)builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 1));
    }

    static {
        PluginManager.addPackage(EcsLayout.class.getPackage().getName());
        PluginManager.addPackage(LoggerContext.class.getPackage().getName());
    }
}

