/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongoclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.mongoclient.MongoClientInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Connection;
import javax.annotation.Nullable;

public class ConnectionInstrumentation
extends MongoClientInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("insert").or(ElementMatchers.nameStartsWith("update")).or(ElementMatchers.nameStartsWith("delete")).or(ElementMatchers.nameStartsWith("query")).or(ElementMatchers.nameStartsWith("getMore")).and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.mongodb.MongoNamespace")));
    }

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static Span onEnter(@Advice.This Connection thiz, @Advice.Argument(value=0) MongoNamespace namespace, @Advice.Origin(value="#m") String methodName) {
        Span span = ElasticApmInstrumentation.createExitSpan();
        if (span == null) {
            return null;
        }
        span.withType("db").withSubtype("mongodb").getContext().getDb().withType("mongodb");
        span.getContext().getDestination().getService().withName("mongodb").withResource("mongodb").withType("db");
        ServerAddress serverAddress = thiz.getDescription().getServerAddress();
        span.getContext().getDestination().withAddress(serverAddress.getHost()).withPort(serverAddress.getPort());
        String command = methodName;
        if (methodName.equals("query")) {
            command = "find";
        }
        span.withAction(command);
        StringBuilder spanName = span.getAndOverrideName(0);
        if (spanName != null) {
            int indexOfCommand = command.indexOf("Command");
            spanName.append(namespace.getDatabaseName()).append(".").append(namespace.getCollectionName()).append(".").append(command, 0, indexOfCommand > 0 ? indexOfCommand : command.length());
        }
        span.activate();
        return span;
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onExit(@Nullable @Advice.Enter Span span, @Advice.Thrown Throwable thrown) {
        if (span != null) {
            ((Span)span.deactivate()).captureException(thrown);
            span.end();
        }
    }
}

