/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.okhttp.AbstractOkHttp3ClientInstrumentation;
import co.elastic.apm.agent.okhttp.OkHttpClientHelper;
import co.elastic.apm.agent.okhttp.WrapperCreator;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3ClientAsyncInstrumentation
extends AbstractOkHttp3ClientInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(OkHttp3ClientAsyncInstrumentation.class);
    @Nullable
    public static HelperClassManager<WrapperCreator<Callback>> callbackWrapperCreator;

    @Override
    public Class<?> getAdviceClass() {
        return OkHttpClient3ExecuteAdvice.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttp3ClientAsyncInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
        Class<OkHttp3ClientAsyncInstrumentation> clazz = OkHttp3ClientAsyncInstrumentation.class;
        synchronized (OkHttp3ClientAsyncInstrumentation.class) {
            if (callbackWrapperCreator == null) {
                callbackWrapperCreator = HelperClassManager.ForAnyClassLoader.of(tracer, OkHttp3ClientAsyncInstrumentation.class.getName() + "$CallbackWrapperCreator", OkHttp3ClientAsyncInstrumentation.class.getName() + "$CallbackWrapperCreator$CallbackWrapper");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("okhttp3.RealCall");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("enqueue").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("okhttp3.Callback"))).and(ElementMatchers.returns(Void.TYPE));
    }

    public static class CallbackWrapperCreator
    implements WrapperCreator<Callback> {
        @Override
        public Callback wrap(Callback delegate, Span span) {
            return new CallbackWrapper(span, delegate);
        }

        private static class CallbackWrapper
        implements Callback {
            private final Span span;
            private final Callback delegate;

            CallbackWrapper(Span span, Callback delegate) {
                this.span = span;
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call call, IOException e) {
                try {
                    ((Span)this.span.captureException(e)).end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onFailure(call, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    this.span.getContext().getHttp().withStatusCode(response.code());
                    this.span.end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onResponse(call, response);
                }
            }
        }
    }

    public static class OkHttpClient3ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeEnqueue(@Advice.Origin Class<? extends Call> clazz, @Advice.FieldValue(value="originalRequest", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable Request originalRequest, @Advice.Argument(value=0, readOnly=false) @Nullable Callback callback, @Advice.Local(value="span") Span span) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null || callbackWrapperCreator == null) {
                return;
            }
            WrapperCreator<Callback> wrapperCreator = callbackWrapperCreator.getForClassLoaderOfClass(clazz);
            if (originalRequest == null || callback == null || wrapperCreator == null) {
                return;
            }
            AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
            Request request = originalRequest;
            HttpUrl url = request.url();
            span = HttpClientHelper.startHttpClientSpan(parent, request.method(), url.toString(), url.scheme(), OkHttpClientHelper.computeHostName(url.host()), url.port());
            if (span != null) {
                TextHeaderSetter<Request.Builder> headerSetter;
                span.activate();
                if (AbstractOkHttp3ClientInstrumentation.headerSetterHelperManager != null && (headerSetter = AbstractOkHttp3ClientInstrumentation.headerSetterHelperManager.getForClassLoaderOfClass(Request.class)) != null) {
                    Request.Builder builder = originalRequest.newBuilder();
                    span.propagateTraceContext(builder, headerSetter);
                    originalRequest = builder.build();
                }
                callback = wrapperCreator.wrap(callback, span);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void onAfterEnqueue(@Advice.Local(value="span") @Nullable Span span) {
            if (span != null) {
                span.deactivate();
            }
        }
    }
}

