/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.okhttp.AbstractOkHttpClientInstrumentation;
import co.elastic.apm.agent.okhttp.OkHttpClientHelper;
import co.elastic.apm.agent.okhttp.WrapperCreator;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;

public class OkHttpClientAsyncInstrumentation
extends AbstractOkHttpClientInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(OkHttpClientAsyncInstrumentation.class);
    @Nullable
    public static HelperClassManager<WrapperCreator<Callback>> callbackWrapperCreator;

    @Override
    public Class<?> getAdviceClass() {
        return OkHttpClient3ExecuteAdvice.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClientAsyncInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
        Class<OkHttpClientAsyncInstrumentation> clazz = OkHttpClientAsyncInstrumentation.class;
        synchronized (OkHttpClientAsyncInstrumentation.class) {
            if (callbackWrapperCreator == null) {
                callbackWrapperCreator = HelperClassManager.ForAnyClassLoader.of(tracer, OkHttpClientAsyncInstrumentation.class.getName() + "$CallbackWrapperCreator", OkHttpClientAsyncInstrumentation.class.getName() + "$CallbackWrapperCreator$CallbackWrapper");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.squareup.okhttp.Call");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("enqueue").and(ElementMatchers.returns(Void.TYPE));
    }

    public static class CallbackWrapperCreator
    implements WrapperCreator<Callback> {
        @Override
        public Callback wrap(Callback delegate, Span span) {
            return new CallbackWrapper(span, delegate);
        }

        private static class CallbackWrapper
        implements Callback {
            private final Span span;
            private final Callback delegate;

            CallbackWrapper(Span span, Callback delegate) {
                this.span = span;
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Request req, IOException e) {
                try {
                    ((Span)this.span.captureException(e)).end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onFailure(req, e);
                }
            }

            public void onResponse(Response response) throws IOException {
                try {
                    this.span.getContext().getHttp().withStatusCode(response.code());
                    this.span.end();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    this.delegate.onResponse(response);
                }
            }
        }
    }

    public static class OkHttpClient3ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeEnqueue(@Advice.Origin Class<? extends Call> clazz, @Advice.FieldValue(value="originalRequest", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable Request originalRequest, @Advice.Argument(value=0, readOnly=false) @Nullable Callback callback, @Advice.Local(value="span") Span span) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null || callbackWrapperCreator == null) {
                return;
            }
            WrapperCreator<Callback> wrapperCreator = callbackWrapperCreator.getForClassLoaderOfClass(clazz);
            if (originalRequest == null || callback == null || wrapperCreator == null) {
                return;
            }
            AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
            Request request = originalRequest;
            URL url = request.url();
            span = HttpClientHelper.startHttpClientSpan(parent, request.method(), url.toString(), url.getProtocol(), OkHttpClientHelper.computeHostName(url.getHost()), url.getPort());
            if (span != null) {
                TextHeaderSetter<Request.Builder> headerSetter;
                span.activate();
                if (AbstractOkHttpClientInstrumentation.headerSetterHelperManager != null && (headerSetter = AbstractOkHttpClientInstrumentation.headerSetterHelperManager.getForClassLoaderOfClass(Request.class)) != null) {
                    Request.Builder builder = originalRequest.newBuilder();
                    span.propagateTraceContext(builder, headerSetter);
                    originalRequest = builder.build();
                }
                callback = wrapperCreator.wrap(callback, span);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void onAfterEnqueue(@Advice.Local(value="span") @Nullable Span span) {
            if (span != null) {
                span.deactivate();
            }
        }
    }
}

