/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class CaptureTransactionInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(CaptureTransactionInstrumentation.class);
    private final StacktraceConfiguration config;

    public CaptureTransactionInstrumentation(ElasticApmTracer tracer) {
        this.config = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureTransaction", method="value") String transactionName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureTransaction", method="type") String type, @Advice.Local(value="transaction") Transaction transaction) {
        if (tracer != null) {
            AbstractSpan<?> active = tracer.getActive();
            if (active == null) {
                transaction = tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    if (transactionName.isEmpty()) {
                        transaction.withName(signature, 100);
                    } else {
                        transaction.withName(transactionName, 1000);
                    }
                    transaction.withType(type).activate();
                    transaction.setFrameworkName("API");
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExit(@Nullable @Advice.Local(value="transaction") Transaction transaction, @Advice.Thrown Throwable t) {
        if (transaction != null) {
            ((Transaction)((Transaction)transaction.captureException(t)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.CaptureTransaction");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.config.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureTransaction"));
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations");
    }
}

