/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.process.BaseProcessInstrumentation;
import co.elastic.apm.agent.process.ProcessHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class ProcessStartInstrumentation
extends BaseProcessInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("java.lang.ProcessBuilder");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("start").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ProcessBuilderStartAdvice.class;
    }

    public static class ProcessBuilderStartAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onExit(@Advice.This ProcessBuilder processBuilder, @Advice.Return Process process, @Advice.Thrown @Nullable Throwable t) {
            if (ElasticApmInstrumentation.tracer == null) {
                return;
            }
            AbstractSpan<?> parentSpan = ElasticApmInstrumentation.tracer.getActive();
            if (parentSpan == null) {
                return;
            }
            if (t != null) {
                parentSpan.captureException(t);
            }
            ProcessHelper.startProcess(parentSpan, process, processBuilder.command());
        }
    }
}

