/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.ApmServerHealthChecker;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ssl.SslUtils;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.util.GlobalLocks;
import co.elastic.apm.agent.util.Version;
import co.elastic.apm.agent.util.VersionUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class ApmServerClient {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerClient.class);
    private static final String USER_AGENT = "elasticapm-java/" + VersionUtils.getAgentVersion();
    private static final Version VERSION_6_7 = Version.of("6.7.0");
    private static final Version VERSION_7_9 = Version.of("7.9.0");
    private final ReporterConfiguration reporterConfiguration;
    @Nullable
    private volatile List<URL> serverUrls;
    @Nullable
    private volatile Future<Version> apmServerVersion;
    private final AtomicInteger errorCount = new AtomicInteger();
    private final ApmServerHealthChecker healthChecker;

    public ApmServerClient(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
        this.healthChecker = new ApmServerHealthChecker(this);
    }

    public void start() {
        this.start(ApmServerClient.shuffleUrls(this.reporterConfiguration.getServerUrls()));
    }

    public void start(List<URL> shuffledUrls) {
        this.reporterConfiguration.getServerUrlsOption().addChangeListener(new ConfigurationOption.ChangeListener<List<URL>>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, List<URL> oldValue, List<URL> newValue) {
                logger.debug("server_urls override with value = ({}).", (Object)newValue);
                if (newValue != null && !newValue.isEmpty()) {
                    ApmServerClient.this.setServerUrls(ApmServerClient.shuffleUrls(newValue));
                }
            }
        });
        this.setServerUrls(Collections.unmodifiableList(shuffledUrls));
    }

    private void setServerUrls(List<URL> serverUrls) {
        this.serverUrls = serverUrls;
        this.apmServerVersion = this.healthChecker.checkHealthAndGetMinVersion();
        this.errorCount.set(0);
    }

    private static List<URL> shuffleUrls(List<URL> serverUrls) {
        ArrayList<URL> copy = new ArrayList<URL>(serverUrls);
        Collections.shuffle(copy);
        return copy;
    }

    HttpURLConnection startRequest(String relativePath) throws IOException {
        return this.startRequestToUrl(this.appendPathToCurrentUrl(relativePath));
    }

    @Nonnull
    private HttpURLConnection startRequestToUrl(URL url) throws IOException {
        URLConnection connection = this.openUrlConnectionThreadSafely(url);
        if (connection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory;
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            boolean verifyServerCert = this.reporterConfiguration.isVerifyServerCert();
            if (!verifyServerCert) {
                httpsConnection.setHostnameVerifier(SslUtils.getTrustAllHostnameVerifyer());
            }
            if ((sslSocketFactory = SslUtils.getSSLSocketFactory(verifyServerCert)) != null) {
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
            }
        }
        String secretToken = this.reporterConfiguration.getSecretToken();
        String apiKey = this.reporterConfiguration.getApiKey();
        String authHeaderValue = null;
        if (apiKey != null) {
            authHeaderValue = String.format("ApiKey %s", apiKey);
        } else if (secretToken != null) {
            authHeaderValue = String.format("Bearer %s", secretToken);
        }
        if (authHeaderValue != null) {
            connection.setRequestProperty("Authorization", authHeaderValue);
        }
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setConnectTimeout((int)this.reporterConfiguration.getServerTimeout().getMillis());
        connection.setReadTimeout((int)this.reporterConfiguration.getServerTimeout().getMillis());
        return (HttpURLConnection)connection;
    }

    private URLConnection openUrlConnectionThreadSafely(URL url) throws IOException {
        GlobalLocks.JUL_INIT_LOCK.lock();
        try {
            URLConnection uRLConnection = url.openConnection();
            return uRLConnection;
        }
        finally {
            GlobalLocks.JUL_INIT_LOCK.unlock();
        }
    }

    @Nonnull
    URL appendPathToCurrentUrl(String apmServerPath) throws MalformedURLException {
        return this.appendPath(this.getCurrentUrl(), apmServerPath);
    }

    @Nonnull
    private URL appendPath(URL serverUrl, String apmServerPath) throws MalformedURLException {
        String path = serverUrl.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return new URL(serverUrl, path + apmServerPath);
    }

    int incrementAndGetErrorCount(int expectedErrorCount) {
        boolean success = this.errorCount.compareAndSet(expectedErrorCount, expectedErrorCount + 1);
        if (success) {
            return expectedErrorCount + 1;
        }
        return -1;
    }

    void onConnectionError() {
        this.errorCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V execute(String path, ConnectionHandler<V> connectionHandler) throws Exception {
        List<URL> prioritizedUrlList = this.getPrioritizedUrlList();
        if (prioritizedUrlList.isEmpty()) {
            return null;
        }
        int expectedErrorCount = this.errorCount.get();
        Exception previousException = null;
        for (URL serverUrl : prioritizedUrlList) {
            V v;
            HttpURLConnection connection = null;
            try {
                connection = this.startRequestToUrl(this.appendPath(serverUrl, path));
                v = connectionHandler.withConnection(connection);
            }
            catch (Exception e) {
                try {
                    expectedErrorCount = this.incrementAndGetErrorCount(expectedErrorCount);
                    logger.debug("Exception while interacting with APM Server, trying next one.");
                    if (previousException != null) {
                        e.addSuppressed(previousException);
                    }
                    previousException = e;
                }
                catch (Throwable throwable) {
                    HttpUtils.consumeAndClose(connection);
                    throw throwable;
                }
                HttpUtils.consumeAndClose(connection);
                continue;
            }
            HttpUtils.consumeAndClose(connection);
            return v;
        }
        if (previousException == null) {
            throw new IllegalStateException("Expected previousException not to be null");
        }
        throw previousException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeForAllUrls(String path, ConnectionHandler<T> connectionHandler) {
        List<URL> serverUrls = this.getServerUrls();
        ArrayList<T> results = new ArrayList<T>(serverUrls.size());
        for (URL serverUrl : serverUrls) {
            HttpURLConnection connection = null;
            try {
                connection = this.startRequestToUrl(this.appendPath(serverUrl, path));
                results.add(connectionHandler.withConnection(connection));
            }
            catch (Exception e) {
                try {
                    logger.debug("Exception while interacting with APM Server", e);
                }
                catch (Throwable throwable) {
                    HttpUtils.consumeAndClose(connection);
                    throw throwable;
                }
                HttpUtils.consumeAndClose(connection);
                continue;
            }
            HttpUtils.consumeAndClose(connection);
        }
        return results;
    }

    URL getCurrentUrl() {
        List<URL> serverUrls = this.getServerUrls();
        return serverUrls.get(this.errorCount.get() % serverUrls.size());
    }

    @Nonnull
    private List<URL> getPrioritizedUrlList() {
        ArrayList<URL> serverUrlsCopy = new ArrayList<URL>(this.getServerUrls());
        Collections.rotate(serverUrlsCopy, this.errorCount.get());
        return serverUrlsCopy;
    }

    int getErrorCount() {
        return this.errorCount.get();
    }

    List<URL> getServerUrls() {
        if (this.serverUrls == null) {
            throw new IllegalStateException("APM Server client not yet initialized");
        }
        return this.serverUrls;
    }

    public boolean supportsNonStringLabels() {
        return this.isAtLeast(VERSION_6_7);
    }

    public boolean supportsLogsEndpoint() {
        return this.isAtLeast(VERSION_7_9);
    }

    public boolean isAtLeast(Version apmServerVersion) {
        if (this.apmServerVersion == null) {
            throw new IllegalStateException("Called before init event");
        }
        try {
            Version localApmServerVersion = this.apmServerVersion.get();
            if (localApmServerVersion == null) {
                return false;
            }
            return localApmServerVersion.compareTo(apmServerVersion) >= 0;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return false;
        }
    }

    public static interface ConnectionHandler<T> {
        @Nullable
        public T withConnection(HttpURLConnection var1) throws IOException;
    }
}

