/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.configuration.converter.ByteValue;
import co.elastic.apm.agent.configuration.converter.ByteValueConverter;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.configuration.validation.RangeValidator;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.ListValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.UrlValueConverter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ReporterConfiguration
extends ConfigurationOptionProvider {
    public static final String REPORTER_CATEGORY = "Reporter";
    private final ConfigurationOption<String> secretToken = ConfigurationOption.stringOption().key("secret_token").configurationCategory("Reporter").description("This string is used to ensure that only your agents can send data to your APM server.\n\nBoth the agents and the APM server have to be configured with the same secret token.\nUse if APM Server requires a token.").sensitive().build();
    private final ConfigurationOption<String> apiKey = ConfigurationOption.stringOption().key("api_key").configurationCategory("Reporter").description("This string is used to ensure that only your agents can send data to your APM server.\n\nAgents can use API keys as a replacement of secret token, APM server can have multiple API keys.\nWhen both secret token and API key are used, API key has priority and secret token is ignored.\nUse if APM Server requires an API key.").sensitive().build();
    private final ConfigurationOption<List<URL>> serverUrl = ConfigurationOption.urlsOption().key("server_urls").aliasKeys("server_url").configurationCategory("Reporter").label("The URLs for your APM Servers").description("The URLs must be fully qualified, including protocol (http or https) and port.\n\nFails over to the next APM Server URL in the event of connection errors.\nAchieves load-balancing by shuffling the list of configured URLs.\nWhen multiple agents are active, they'll tend towards spreading evenly across the set of servers due to randomization.\n\nIf outgoing HTTP traffic has to go through a proxy,you can use the Java system properties `http.proxyHost` and `http.proxyPort` to set that up.\nSee also [Java's proxy documentation](https://docs.oracle.com/javase/8/docs/technotes/guides/net/proxies.html) for more information.\n\nNOTE: This configuration can only be reloaded dynamically as of 1.8.0").dynamic(true).buildWithDefault(Collections.singletonList(UrlValueConverter.INSTANCE.convert("http://localhost:8200")));
    private final ConfigurationOption<TimeDuration> serverTimeout = TimeDurationValueConverter.durationOption("s").key("server_timeout").configurationCategory("Reporter").label("Server timeout").description("If a request to the APM server takes longer than the configured timeout,\nthe request is cancelled and the event (exception or transaction) is discarded.\nSet to 0 to disable timeouts.\n\nWARNING: If timeouts are disabled or set to a high value, your app could experience memory issues if the APM server times out.").dynamic(true).buildWithDefault(TimeDuration.of("5s"));
    private final ConfigurationOption<Boolean> verifyServerCert = ConfigurationOption.booleanOption().key("verify_server_cert").configurationCategory("Reporter").description("By default, the agent verifies the SSL certificate if you use an HTTPS connection to the APM server.\n\nVerification can be disabled by changing this setting to false.").buildWithDefault(true);
    private final ConfigurationOption<Integer> maxQueueSize = ConfigurationOption.integerOption().key("max_queue_size").configurationCategory("Reporter").description("The maximum size of buffered events.\n\nEvents like transactions and spans are buffered when the agent can't keep up with sending them to the APM Server or if the APM server is down.\n\nIf the queue is full, events are rejected which means you will lose transactions and spans in that case.\nThis guards the application from crashing in case the APM server is unavailable for a longer period of time.\n\nA lower value will decrease the heap overhead of the agent,\nwhile a higher value makes it less likely to lose events in case of a temporary spike in throughput.").dynamic(true).buildWithDefault(512);
    private final ConfigurationOption<Boolean> reportSynchronously = ConfigurationOption.booleanOption().key("report_sync").tags("internal").configurationCategory("Reporter").description("Only to be used for testing purposes. Blocks the requests until the transaction has been reported to the APM server.").buildWithDefault(false);
    private final ConfigurationOption<Boolean> includeProcessArguments = ConfigurationOption.booleanOption().key("include_process_args").configurationCategory("Reporter").description("Whether each transaction should have the process arguments attached.\nDisabled by default to save disk space.").buildWithDefault(false);
    private final ConfigurationOption<TimeDuration> apiRequestTime = TimeDurationValueConverter.durationOption("s").key("api_request_time").configurationCategory("Reporter").dynamic(true).description("Maximum time to keep an HTTP request to the APM Server open for.\n\nNOTE: This value has to be lower than the APM Server's `read_timeout` setting.").buildWithDefault(TimeDuration.of("10s"));
    private final ConfigurationOption<ByteValue> apiRequestSize = ByteValueConverter.byteOption().key("api_request_size").configurationCategory("Reporter").dynamic(true).description("The maximum total compressed size of the request body which is sent to the APM server intake api via a chunked encoding (HTTP streaming).\nNote that a small overshoot is possible.\n\nAllowed byte units are `b`, `kb` and `mb`. `1kb` is equal to `1024b`.").buildWithDefault(ByteValue.of("768kb"));
    private final ConfigurationOption<TimeDuration> metricsInterval = TimeDurationValueConverter.durationOption("s").key("metrics_interval").tags("added[1.3.0]").configurationCategory("Reporter").description("The interval at which the agent sends metrics to the APM Server.\nMust be at least `1s`.\nSet to `0s` to deactivate.").addValidator(RangeValidator.isNotInRange(TimeDuration.of("1ms"), TimeDuration.of("999ms"))).buildWithDefault(TimeDuration.of("30s"));
    private final ConfigurationOption<List<WildcardMatcher>> disableMetrics = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("disable_metrics").tags("added[1.3.0]").configurationCategory("Reporter").description("Disables the collection of certain metrics.\nIf the name of a metric matches any of the wildcard expressions, it will not be collected.\nExample: `foo.*,bar.*`\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(false).buildWithDefault(Collections.emptyList());

    @Nullable
    public String getSecretToken() {
        return this.secretToken.get();
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey.get();
    }

    public List<URL> getServerUrls() {
        return this.serverUrl.get();
    }

    public TimeDuration getServerTimeout() {
        return this.serverTimeout.get();
    }

    public boolean isVerifyServerCert() {
        return this.verifyServerCert.get();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize.get();
    }

    public boolean isReportSynchronously() {
        return this.reportSynchronously.get();
    }

    public boolean isIncludeProcessArguments() {
        return this.includeProcessArguments.get();
    }

    public TimeDuration getApiRequestTime() {
        return this.apiRequestTime.get();
    }

    public long getApiRequestSize() {
        return this.apiRequestSize.get().getBytes();
    }

    public long getMetricsIntervalMs() {
        return this.metricsInterval.get().getMillis();
    }

    public List<WildcardMatcher> getDisableMetrics() {
        return this.disableMetrics.get();
    }

    public ConfigurationOption<List<URL>> getServerUrlsOption() {
        return this.serverUrl;
    }
}

