/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.metrics.MetricRegistry;
import javax.annotation.Nullable;

public class ReportingEvent {
    @Nullable
    private Transaction transaction;
    @Nullable
    private ReportingEventType type;
    @Nullable
    private ErrorCapture error;
    @Nullable
    private Span span;
    @Nullable
    private MetricRegistry metricRegistry;

    public void resetState() {
        this.transaction = null;
        this.type = null;
        this.error = null;
        this.span = null;
        this.metricRegistry = null;
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
        this.type = ReportingEventType.TRANSACTION;
    }

    public void setFlushEvent() {
        this.type = ReportingEventType.FLUSH;
    }

    @Nullable
    public ReportingEventType getType() {
        return this.type;
    }

    @Nullable
    public ErrorCapture getError() {
        return this.error;
    }

    @Nullable
    public Span getSpan() {
        return this.span;
    }

    public void setError(ErrorCapture error) {
        this.error = error;
        this.type = ReportingEventType.ERROR;
    }

    public void setSpan(Span span) {
        this.span = span;
        this.type = ReportingEventType.SPAN;
    }

    public void reportMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.type = ReportingEventType.METRICS;
    }

    public void shutdownEvent() {
        this.type = ReportingEventType.SHUTDOWN;
    }

    @Nullable
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    static enum ReportingEventType {
        FLUSH,
        TRANSACTION,
        SPAN,
        ERROR,
        METRICS,
        SHUTDOWN;

    }
}

