/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.ssl;

import co.elastic.apm.agent.report.ssl.TLSFallbackSSLSocketFactory;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private static final Logger logger = LoggerFactory.getLogger(SslUtils.class);
    private static final HostnameVerifier hostnameVerifier;
    @Nullable
    private static final SSLSocketFactory validateSocketFactory;
    @Nullable
    private static final SSLSocketFactory trustAllSocketFactory;

    public static HostnameVerifier getTrustAllHostnameVerifyer() {
        return hostnameVerifier;
    }

    @Nullable
    public static SSLSocketFactory getSSLSocketFactory(boolean validateCertificates) {
        return validateCertificates ? validateSocketFactory : trustAllSocketFactory;
    }

    @Nullable
    private static SSLSocketFactory createTrustAllSocketFactory(X509TrustManager trustAllTrustManager) {
        return SslUtils.createSocketFactory(new TrustManager[]{trustAllTrustManager});
    }

    @Nullable
    private static SSLSocketFactory createSocketFactory(TrustManager[] trustAllCerts) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.warn(e.getMessage(), e);
            return null;
        }
    }

    private static X509TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    static {
        X509TrustManager trustAllTrustManager = SslUtils.createTrustAllTrustManager();
        validateSocketFactory = TLSFallbackSSLSocketFactory.wrapFactory(SslUtils.createSocketFactory(null));
        trustAllSocketFactory = TLSFallbackSSLSocketFactory.wrapFactory(SslUtils.createSocketFactory(new TrustManager[]{trustAllTrustManager}));
        hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }
}

