/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.ssl;

import co.elastic.apm.agent.report.ssl.TLSFallbackSSLSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class TLSFallbackSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory factory;
    private final AtomicBoolean skipTLS13;

    private TLSFallbackSSLSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
        this.skipTLS13 = new AtomicBoolean(false);
    }

    @Nullable
    static TLSFallbackSSLSocketFactory wrapFactory(@Nullable SSLSocketFactory factory) {
        if (factory == null) {
            return null;
        }
        return new TLSFallbackSSLSocketFactory(factory);
    }

    AtomicBoolean skipTLS13() {
        return this.skipTLS13;
    }

    SSLSocketFactory getOriginalFactory() {
        return this.factory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.wrapSocket(this.factory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrapSocket(this.factory.createSocket());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.wrapSocket(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.wrapSocket(this.factory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.wrapSocket(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.wrapSocket(this.factory.createSocket(address, port, localAddress, localPort));
    }

    private Socket wrapSocket(Socket socket) {
        return new TLSFallbackSSLSocket((SSLSocket)socket, this);
    }
}

