/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.visitors;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.LogEvent;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Configuration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Node;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.PluginValue;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.visitors.AbstractPluginVisitor;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.StringBuilders;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.Strings;

public class PluginValueVisitor
extends AbstractPluginVisitor<PluginValue> {
    public PluginValueVisitor() {
        super(PluginValue.class);
    }

    @Override
    public Object visit(Configuration configuration, Node node, LogEvent event, StringBuilder log) {
        String name = ((PluginValue)this.annotation).value();
        String elementValue = node.getValue();
        String attributeValue = node.getAttributes().get("value");
        String rawValue = null;
        if (Strings.isNotEmpty(elementValue)) {
            if (Strings.isNotEmpty(attributeValue)) {
                LOGGER.error("Configuration contains {} with both attribute value ({}) AND element value ({}). Please specify only one value. Using the element value.", (Object)node.getName(), (Object)attributeValue, (Object)elementValue);
            }
            rawValue = elementValue;
        } else {
            rawValue = PluginValueVisitor.removeAttributeValue(node.getAttributes(), "value", new String[0]);
        }
        String value = this.substitutor.replace(event, rawValue);
        StringBuilders.appendKeyDqValue(log, name, value);
        return value;
    }
}

