/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.properties;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.LoggerContext;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationException;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationFactory;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationSource;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Order;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.Plugin;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@Plugin(name="PropertiesConfigurationFactory", category="ConfigurationFactory")
@Order(value=8)
public class PropertiesConfigurationFactory
extends ConfigurationFactory {
    @Override
    protected String[] getSupportedTypes() {
        return new String[]{".properties"};
    }

    @Override
    public PropertiesConfiguration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        Properties properties = new Properties();
        try (InputStream configStream = source.getInputStream();){
            properties.load(configStream);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to load " + source.toString(), ioe);
        }
        return new PropertiesConfigurationBuilder().setConfigurationSource(source).setRootProperties(properties).setLoggerContext(loggerContext).build();
    }
}

