/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.impl;

import co.elastic.apm.agent.shaded.apache.logging.log4j.ThreadContext;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.ContextDataInjector;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.Loader;
import co.elastic.apm.agent.shaded.apache.logging.log4j.spi.CopyOnWrite;
import co.elastic.apm.agent.shaded.apache.logging.log4j.spi.DefaultThreadContextMap;
import co.elastic.apm.agent.shaded.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import co.elastic.apm.agent.shaded.apache.logging.log4j.status.StatusLogger;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.PropertiesUtil;

public class ContextDataInjectorFactory {
    public static ContextDataInjector createInjector() {
        String className = PropertiesUtil.getProperties().getStringProperty("elasticapmlog4j2.ContextDataInjector");
        if (className == null) {
            return ContextDataInjectorFactory.createDefaultInjector();
        }
        try {
            Class<ContextDataInjector> cls = Loader.loadClass(className).asSubclass(ContextDataInjector.class);
            return cls.newInstance();
        }
        catch (Exception dynamicFailed) {
            ContextDataInjector result = ContextDataInjectorFactory.createDefaultInjector();
            StatusLogger.getLogger().warn("Could not create ContextDataInjector for '{}', using default {}: {}", (Object)className, (Object)result.getClass().getName(), (Object)dynamicFailed);
            return result;
        }
    }

    private static ContextDataInjector createDefaultInjector() {
        ReadOnlyThreadContextMap threadContextMap = ThreadContext.getThreadContextMap();
        if (threadContextMap instanceof DefaultThreadContextMap || threadContextMap == null) {
            return new ThreadContextDataInjector.ForDefaultThreadContextMap();
        }
        if (threadContextMap instanceof CopyOnWrite) {
            return new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap();
        }
        return new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
    }
}

