/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.net.ssl;

import co.elastic.apm.agent.shaded.apache.logging.log4j.Logger;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.net.ssl.SslConfiguration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.status.StatusLogger;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.PropertiesUtil;

public class SslConfigurationFactory {
    private static final Logger LOGGER;
    private static SslConfiguration sslConfiguration;
    private static final String trustStorelocation = "elasticapmlog4j2.trustStoreLocation";
    private static final String trustStorePassword = "elasticapmlog4j2.trustStorePassword";
    private static final String trustStorePasswordFile = "elasticapmlog4j2.trustStorePasswordFile";
    private static final String trustStorePasswordEnvVar = "elasticapmlog4j2.trustStorePasswordEnvironmentVariable";
    private static final String trustStoreKeyStoreType = "elasticapmlog4j2.trustStoreKeyStoreType";
    private static final String trustStoreKeyManagerFactoryAlgorithm = "elasticapmlog4j2.trustStoreKeyManagerFactoryAlgorithm";
    private static final String keyStoreLocation = "elasticapmlog4j2.keyStoreLocation";
    private static final String keyStorePassword = "elasticapmlog4j2.keyStorePassword";
    private static final String keyStorePasswordFile = "elasticapmlog4j2.keyStorePasswordFile";
    private static final String keyStorePasswordEnvVar = "elasticapmlog4j2.keyStorePasswordEnvironmentVariable";
    private static final String keyStoreType = "elasticapmlog4j2.keyStoreType";
    private static final String keyStoreKeyManagerFactoryAlgorithm = "elasticapmlog4j2.keyStoreKeyManagerFactoryAlgorithm";
    private static final String verifyHostName = "elasticapmlog4j2.sslVerifyHostName";

    public static SslConfiguration getSslConfiguration() {
        return sslConfiguration;
    }

    static {
        char[] passwordChars;
        String password;
        LOGGER = StatusLogger.getLogger();
        sslConfiguration = null;
        PropertiesUtil props = PropertiesUtil.getProperties();
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustStoreConfiguration trustStoreConfiguration = null;
        String location = props.getStringProperty(trustStorelocation);
        if (location != null) {
            password = props.getStringProperty(trustStorePassword);
            passwordChars = null;
            if (password != null) {
                passwordChars = password.toCharArray();
            }
            try {
                trustStoreConfiguration = TrustStoreConfiguration.createKeyStoreConfiguration(location, passwordChars, props.getStringProperty(trustStorePasswordEnvVar), props.getStringProperty(trustStorePasswordFile), props.getStringProperty(trustStoreKeyStoreType), props.getStringProperty(trustStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to create trust store configuration due to: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
        }
        if ((location = props.getStringProperty(keyStoreLocation)) != null) {
            password = props.getStringProperty(keyStorePassword);
            passwordChars = null;
            if (password != null) {
                passwordChars = password.toCharArray();
            }
            try {
                keyStoreConfiguration = KeyStoreConfiguration.createKeyStoreConfiguration(location, passwordChars, props.getStringProperty(keyStorePasswordEnvVar), props.getStringProperty(keyStorePasswordFile), props.getStringProperty(keyStoreType), props.getStringProperty(keyStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to create key store configuration due to: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
        }
        if (trustStoreConfiguration != null || keyStoreConfiguration != null) {
            boolean isVerifyHostName = props.getBooleanProperty(verifyHostName, false);
            sslConfiguration = SslConfiguration.createSSLConfiguration("https", keyStoreConfiguration, trustStoreConfiguration, isVerifyHostName);
        }
    }
}

